// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Routing rules in production experiments.
 */
@Fluent
public final class Experiments implements JsonSerializable<Experiments> {
    /*
     * List of ramp-up rules.
     */
    private List<RampUpRule> rampUpRules;

    /**
     * Creates an instance of Experiments class.
     */
    public Experiments() {
    }

    /**
     * Get the rampUpRules property: List of ramp-up rules.
     * 
     * @return the rampUpRules value.
     */
    public List<RampUpRule> rampUpRules() {
        return this.rampUpRules;
    }

    /**
     * Set the rampUpRules property: List of ramp-up rules.
     * 
     * @param rampUpRules the rampUpRules value to set.
     * @return the Experiments object itself.
     */
    public Experiments withRampUpRules(List<RampUpRule> rampUpRules) {
        this.rampUpRules = rampUpRules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rampUpRules() != null) {
            rampUpRules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rampUpRules", this.rampUpRules, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Experiments from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Experiments if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the Experiments.
     */
    public static Experiments fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Experiments deserializedExperiments = new Experiments();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("rampUpRules".equals(fieldName)) {
                    List<RampUpRule> rampUpRules = reader.readArray(reader1 -> RampUpRule.fromJson(reader1));
                    deserializedExperiments.rampUpRules = rampUpRules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExperiments;
        });
    }
}
