// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Authentication method to access the storage account for deployment.
 */
@Fluent
public final class FunctionsDeploymentStorageAuthentication
    implements JsonSerializable<FunctionsDeploymentStorageAuthentication> {
    /*
     * Property to select authentication type to access the selected storage account. Available options:
     * SystemAssignedIdentity, UserAssignedIdentity, StorageAccountConnectionString.
     */
    private AuthenticationType type;

    /*
     * Use this property for UserAssignedIdentity. Set the resource ID of the identity. Do not set a value for this
     * property when using other authentication type.
     */
    private String userAssignedIdentityResourceId;

    /*
     * Use this property for StorageAccountConnectionString. Set the name of the app setting that has the storage
     * account connection string. Do not set a value for this property when using other authentication type.
     */
    private String storageAccountConnectionStringName;

    /**
     * Creates an instance of FunctionsDeploymentStorageAuthentication class.
     */
    public FunctionsDeploymentStorageAuthentication() {
    }

    /**
     * Get the type property: Property to select authentication type to access the selected storage account. Available
     * options: SystemAssignedIdentity, UserAssignedIdentity, StorageAccountConnectionString.
     * 
     * @return the type value.
     */
    public AuthenticationType type() {
        return this.type;
    }

    /**
     * Set the type property: Property to select authentication type to access the selected storage account. Available
     * options: SystemAssignedIdentity, UserAssignedIdentity, StorageAccountConnectionString.
     * 
     * @param type the type value to set.
     * @return the FunctionsDeploymentStorageAuthentication object itself.
     */
    public FunctionsDeploymentStorageAuthentication withType(AuthenticationType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the userAssignedIdentityResourceId property: Use this property for UserAssignedIdentity. Set the resource ID
     * of the identity. Do not set a value for this property when using other authentication type.
     * 
     * @return the userAssignedIdentityResourceId value.
     */
    public String userAssignedIdentityResourceId() {
        return this.userAssignedIdentityResourceId;
    }

    /**
     * Set the userAssignedIdentityResourceId property: Use this property for UserAssignedIdentity. Set the resource ID
     * of the identity. Do not set a value for this property when using other authentication type.
     * 
     * @param userAssignedIdentityResourceId the userAssignedIdentityResourceId value to set.
     * @return the FunctionsDeploymentStorageAuthentication object itself.
     */
    public FunctionsDeploymentStorageAuthentication
        withUserAssignedIdentityResourceId(String userAssignedIdentityResourceId) {
        this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
        return this;
    }

    /**
     * Get the storageAccountConnectionStringName property: Use this property for StorageAccountConnectionString. Set
     * the name of the app setting that has the storage account connection string. Do not set a value for this property
     * when using other authentication type.
     * 
     * @return the storageAccountConnectionStringName value.
     */
    public String storageAccountConnectionStringName() {
        return this.storageAccountConnectionStringName;
    }

    /**
     * Set the storageAccountConnectionStringName property: Use this property for StorageAccountConnectionString. Set
     * the name of the app setting that has the storage account connection string. Do not set a value for this property
     * when using other authentication type.
     * 
     * @param storageAccountConnectionStringName the storageAccountConnectionStringName value to set.
     * @return the FunctionsDeploymentStorageAuthentication object itself.
     */
    public FunctionsDeploymentStorageAuthentication
        withStorageAccountConnectionStringName(String storageAccountConnectionStringName) {
        this.storageAccountConnectionStringName = storageAccountConnectionStringName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("userAssignedIdentityResourceId", this.userAssignedIdentityResourceId);
        jsonWriter.writeStringField("storageAccountConnectionStringName", this.storageAccountConnectionStringName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FunctionsDeploymentStorageAuthentication from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FunctionsDeploymentStorageAuthentication if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FunctionsDeploymentStorageAuthentication.
     */
    public static FunctionsDeploymentStorageAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FunctionsDeploymentStorageAuthentication deserializedFunctionsDeploymentStorageAuthentication
                = new FunctionsDeploymentStorageAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedFunctionsDeploymentStorageAuthentication.type
                        = AuthenticationType.fromString(reader.getString());
                } else if ("userAssignedIdentityResourceId".equals(fieldName)) {
                    deserializedFunctionsDeploymentStorageAuthentication.userAssignedIdentityResourceId
                        = reader.getString();
                } else if ("storageAccountConnectionStringName".equals(fieldName)) {
                    deserializedFunctionsDeploymentStorageAuthentication.storageAccountConnectionStringName
                        = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFunctionsDeploymentStorageAuthentication;
        });
    }
}
