// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specification for an App Service Environment to use for this resource.
 */
@Fluent
public final class HostingEnvironmentProfile implements JsonSerializable<HostingEnvironmentProfile> {
    /*
     * Resource ID of the App Service Environment.
     */
    private String id;

    /*
     * Name of the App Service Environment.
     */
    private String name;

    /*
     * Resource type of the App Service Environment.
     */
    private String type;

    /**
     * Creates an instance of HostingEnvironmentProfile class.
     */
    public HostingEnvironmentProfile() {
    }

    /**
     * Get the id property: Resource ID of the App Service Environment.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID of the App Service Environment.
     * 
     * @param id the id value to set.
     * @return the HostingEnvironmentProfile object itself.
     */
    public HostingEnvironmentProfile withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Name of the App Service Environment.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Resource type of the App Service Environment.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HostingEnvironmentProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HostingEnvironmentProfile if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the HostingEnvironmentProfile.
     */
    public static HostingEnvironmentProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HostingEnvironmentProfile deserializedHostingEnvironmentProfile = new HostingEnvironmentProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedHostingEnvironmentProfile.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedHostingEnvironmentProfile.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedHostingEnvironmentProfile.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHostingEnvironmentProfile;
        });
    }
}
