// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

/**
 * Site extension type.
 */
public enum SiteExtensionType {
    /**
     * Enum value Gallery.
     */
    GALLERY("Gallery"),

    /**
     * Enum value WebRoot.
     */
    WEB_ROOT("WebRoot");

    /**
     * The actual serialized value for a SiteExtensionType instance.
     */
    private final String value;

    SiteExtensionType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a SiteExtensionType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed SiteExtensionType object, or null if unable to parse.
     */
    public static SiteExtensionType fromString(String value) {
        if (value == null) {
            return null;
        }
        SiteExtensionType[] items = SiteExtensionType.values();
        for (SiteExtensionType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
