// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * MachineKey of an app.
 */
@Fluent
public final class SiteMachineKey implements JsonSerializable<SiteMachineKey> {
    /*
     * MachineKey validation.
     */
    private String validation;

    /*
     * Validation key.
     */
    private String validationKey;

    /*
     * Algorithm used for decryption.
     */
    private String decryption;

    /*
     * Decryption key.
     */
    private String decryptionKey;

    /**
     * Creates an instance of SiteMachineKey class.
     */
    public SiteMachineKey() {
    }

    /**
     * Get the validation property: MachineKey validation.
     * 
     * @return the validation value.
     */
    public String validation() {
        return this.validation;
    }

    /**
     * Set the validation property: MachineKey validation.
     * 
     * @param validation the validation value to set.
     * @return the SiteMachineKey object itself.
     */
    public SiteMachineKey withValidation(String validation) {
        this.validation = validation;
        return this;
    }

    /**
     * Get the validationKey property: Validation key.
     * 
     * @return the validationKey value.
     */
    public String validationKey() {
        return this.validationKey;
    }

    /**
     * Set the validationKey property: Validation key.
     * 
     * @param validationKey the validationKey value to set.
     * @return the SiteMachineKey object itself.
     */
    public SiteMachineKey withValidationKey(String validationKey) {
        this.validationKey = validationKey;
        return this;
    }

    /**
     * Get the decryption property: Algorithm used for decryption.
     * 
     * @return the decryption value.
     */
    public String decryption() {
        return this.decryption;
    }

    /**
     * Set the decryption property: Algorithm used for decryption.
     * 
     * @param decryption the decryption value to set.
     * @return the SiteMachineKey object itself.
     */
    public SiteMachineKey withDecryption(String decryption) {
        this.decryption = decryption;
        return this;
    }

    /**
     * Get the decryptionKey property: Decryption key.
     * 
     * @return the decryptionKey value.
     */
    public String decryptionKey() {
        return this.decryptionKey;
    }

    /**
     * Set the decryptionKey property: Decryption key.
     * 
     * @param decryptionKey the decryptionKey value to set.
     * @return the SiteMachineKey object itself.
     */
    public SiteMachineKey withDecryptionKey(String decryptionKey) {
        this.decryptionKey = decryptionKey;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validation", this.validation);
        jsonWriter.writeStringField("validationKey", this.validationKey);
        jsonWriter.writeStringField("decryption", this.decryption);
        jsonWriter.writeStringField("decryptionKey", this.decryptionKey);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteMachineKey from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteMachineKey if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SiteMachineKey.
     */
    public static SiteMachineKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteMachineKey deserializedSiteMachineKey = new SiteMachineKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("validation".equals(fieldName)) {
                    deserializedSiteMachineKey.validation = reader.getString();
                } else if ("validationKey".equals(fieldName)) {
                    deserializedSiteMachineKey.validationKey = reader.getString();
                } else if ("decryption".equals(fieldName)) {
                    deserializedSiteMachineKey.decryption = reader.getString();
                } else if ("decryptionKey".equals(fieldName)) {
                    deserializedSiteMachineKey.decryptionKey = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteMachineKey;
        });
    }
}
