// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * AseV3NetworkingConfiguration resource specific properties.
 */
@Fluent
public final class AseV3NetworkingConfigurationProperties
    implements JsonSerializable<AseV3NetworkingConfigurationProperties> {
    /*
     * The windowsOutboundIpAddresses property.
     */
    private List<String> windowsOutboundIpAddresses;

    /*
     * The linuxOutboundIpAddresses property.
     */
    private List<String> linuxOutboundIpAddresses;

    /*
     * The externalInboundIpAddresses property.
     */
    private List<String> externalInboundIpAddresses;

    /*
     * The internalInboundIpAddresses property.
     */
    private List<String> internalInboundIpAddresses;

    /*
     * Property to enable and disable new private endpoint connection creation on ASE
     */
    private Boolean allowNewPrivateEndpointConnections;

    /*
     * Property to enable and disable FTP on ASEV3
     */
    private Boolean ftpEnabled;

    /*
     * Property to enable and disable Remote Debug on ASEV3
     */
    private Boolean remoteDebugEnabled;

    /*
     * Customer provided Inbound IP Address. Only able to be set on Ase create.
     */
    private String inboundIpAddressOverride;

    /**
     * Creates an instance of AseV3NetworkingConfigurationProperties class.
     */
    public AseV3NetworkingConfigurationProperties() {
    }

    /**
     * Get the windowsOutboundIpAddresses property: The windowsOutboundIpAddresses property.
     * 
     * @return the windowsOutboundIpAddresses value.
     */
    public List<String> windowsOutboundIpAddresses() {
        return this.windowsOutboundIpAddresses;
    }

    /**
     * Get the linuxOutboundIpAddresses property: The linuxOutboundIpAddresses property.
     * 
     * @return the linuxOutboundIpAddresses value.
     */
    public List<String> linuxOutboundIpAddresses() {
        return this.linuxOutboundIpAddresses;
    }

    /**
     * Get the externalInboundIpAddresses property: The externalInboundIpAddresses property.
     * 
     * @return the externalInboundIpAddresses value.
     */
    public List<String> externalInboundIpAddresses() {
        return this.externalInboundIpAddresses;
    }

    /**
     * Get the internalInboundIpAddresses property: The internalInboundIpAddresses property.
     * 
     * @return the internalInboundIpAddresses value.
     */
    public List<String> internalInboundIpAddresses() {
        return this.internalInboundIpAddresses;
    }

    /**
     * Get the allowNewPrivateEndpointConnections property: Property to enable and disable new private endpoint
     * connection creation on ASE.
     * 
     * @return the allowNewPrivateEndpointConnections value.
     */
    public Boolean allowNewPrivateEndpointConnections() {
        return this.allowNewPrivateEndpointConnections;
    }

    /**
     * Set the allowNewPrivateEndpointConnections property: Property to enable and disable new private endpoint
     * connection creation on ASE.
     * 
     * @param allowNewPrivateEndpointConnections the allowNewPrivateEndpointConnections value to set.
     * @return the AseV3NetworkingConfigurationProperties object itself.
     */
    public AseV3NetworkingConfigurationProperties
        withAllowNewPrivateEndpointConnections(Boolean allowNewPrivateEndpointConnections) {
        this.allowNewPrivateEndpointConnections = allowNewPrivateEndpointConnections;
        return this;
    }

    /**
     * Get the ftpEnabled property: Property to enable and disable FTP on ASEV3.
     * 
     * @return the ftpEnabled value.
     */
    public Boolean ftpEnabled() {
        return this.ftpEnabled;
    }

    /**
     * Set the ftpEnabled property: Property to enable and disable FTP on ASEV3.
     * 
     * @param ftpEnabled the ftpEnabled value to set.
     * @return the AseV3NetworkingConfigurationProperties object itself.
     */
    public AseV3NetworkingConfigurationProperties withFtpEnabled(Boolean ftpEnabled) {
        this.ftpEnabled = ftpEnabled;
        return this;
    }

    /**
     * Get the remoteDebugEnabled property: Property to enable and disable Remote Debug on ASEV3.
     * 
     * @return the remoteDebugEnabled value.
     */
    public Boolean remoteDebugEnabled() {
        return this.remoteDebugEnabled;
    }

    /**
     * Set the remoteDebugEnabled property: Property to enable and disable Remote Debug on ASEV3.
     * 
     * @param remoteDebugEnabled the remoteDebugEnabled value to set.
     * @return the AseV3NetworkingConfigurationProperties object itself.
     */
    public AseV3NetworkingConfigurationProperties withRemoteDebugEnabled(Boolean remoteDebugEnabled) {
        this.remoteDebugEnabled = remoteDebugEnabled;
        return this;
    }

    /**
     * Get the inboundIpAddressOverride property: Customer provided Inbound IP Address. Only able to be set on Ase
     * create.
     * 
     * @return the inboundIpAddressOverride value.
     */
    public String inboundIpAddressOverride() {
        return this.inboundIpAddressOverride;
    }

    /**
     * Set the inboundIpAddressOverride property: Customer provided Inbound IP Address. Only able to be set on Ase
     * create.
     * 
     * @param inboundIpAddressOverride the inboundIpAddressOverride value to set.
     * @return the AseV3NetworkingConfigurationProperties object itself.
     */
    public AseV3NetworkingConfigurationProperties withInboundIpAddressOverride(String inboundIpAddressOverride) {
        this.inboundIpAddressOverride = inboundIpAddressOverride;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowNewPrivateEndpointConnections", this.allowNewPrivateEndpointConnections);
        jsonWriter.writeBooleanField("ftpEnabled", this.ftpEnabled);
        jsonWriter.writeBooleanField("remoteDebugEnabled", this.remoteDebugEnabled);
        jsonWriter.writeStringField("inboundIpAddressOverride", this.inboundIpAddressOverride);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AseV3NetworkingConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AseV3NetworkingConfigurationProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AseV3NetworkingConfigurationProperties.
     */
    public static AseV3NetworkingConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AseV3NetworkingConfigurationProperties deserializedAseV3NetworkingConfigurationProperties
                = new AseV3NetworkingConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("windowsOutboundIpAddresses".equals(fieldName)) {
                    List<String> windowsOutboundIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedAseV3NetworkingConfigurationProperties.windowsOutboundIpAddresses
                        = windowsOutboundIpAddresses;
                } else if ("linuxOutboundIpAddresses".equals(fieldName)) {
                    List<String> linuxOutboundIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedAseV3NetworkingConfigurationProperties.linuxOutboundIpAddresses
                        = linuxOutboundIpAddresses;
                } else if ("externalInboundIpAddresses".equals(fieldName)) {
                    List<String> externalInboundIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedAseV3NetworkingConfigurationProperties.externalInboundIpAddresses
                        = externalInboundIpAddresses;
                } else if ("internalInboundIpAddresses".equals(fieldName)) {
                    List<String> internalInboundIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedAseV3NetworkingConfigurationProperties.internalInboundIpAddresses
                        = internalInboundIpAddresses;
                } else if ("allowNewPrivateEndpointConnections".equals(fieldName)) {
                    deserializedAseV3NetworkingConfigurationProperties.allowNewPrivateEndpointConnections
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("ftpEnabled".equals(fieldName)) {
                    deserializedAseV3NetworkingConfigurationProperties.ftpEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("remoteDebugEnabled".equals(fieldName)) {
                    deserializedAseV3NetworkingConfigurationProperties.remoteDebugEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("inboundIpAddressOverride".equals(fieldName)) {
                    deserializedAseV3NetworkingConfigurationProperties.inboundIpAddressOverride = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAseV3NetworkingConfigurationProperties;
        });
    }
}
