// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AzureResourceType;
import com.azure.resourcemanager.appservice.models.CustomHostnameDnsRecordType;
import com.azure.resourcemanager.appservice.models.HostnameType;
import com.azure.resourcemanager.appservice.models.SslState;
import java.io.IOException;

/**
 * HostNameBinding resource specific properties.
 */
@Fluent
public final class HostnameBindingProperties implements JsonSerializable<HostnameBindingProperties> {
    /*
     * App Service app name.
     */
    private String siteName;

    /*
     * Fully qualified ARM domain resource URI.
     */
    private String domainId;

    /*
     * Azure resource name.
     */
    private String azureResourceName;

    /*
     * Azure resource type.
     */
    private AzureResourceType azureResourceType;

    /*
     * Custom DNS record type.
     */
    private CustomHostnameDnsRecordType customHostnameDnsRecordType;

    /*
     * Hostname type.
     */
    private HostnameType hostnameType;

    /*
     * SSL type
     */
    private SslState sslState;

    /*
     * SSL certificate thumbprint
     */
    private String thumbprint;

    /*
     * Virtual IP address assigned to the hostname if IP based SSL is enabled.
     */
    private String virtualIp;

    /**
     * Creates an instance of HostnameBindingProperties class.
     */
    public HostnameBindingProperties() {
    }

    /**
     * Get the siteName property: App Service app name.
     * 
     * @return the siteName value.
     */
    public String siteName() {
        return this.siteName;
    }

    /**
     * Set the siteName property: App Service app name.
     * 
     * @param siteName the siteName value to set.
     * @return the HostnameBindingProperties object itself.
     */
    public HostnameBindingProperties withSiteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    /**
     * Get the domainId property: Fully qualified ARM domain resource URI.
     * 
     * @return the domainId value.
     */
    public String domainId() {
        return this.domainId;
    }

    /**
     * Set the domainId property: Fully qualified ARM domain resource URI.
     * 
     * @param domainId the domainId value to set.
     * @return the HostnameBindingProperties object itself.
     */
    public HostnameBindingProperties withDomainId(String domainId) {
        this.domainId = domainId;
        return this;
    }

    /**
     * Get the azureResourceName property: Azure resource name.
     * 
     * @return the azureResourceName value.
     */
    public String azureResourceName() {
        return this.azureResourceName;
    }

    /**
     * Set the azureResourceName property: Azure resource name.
     * 
     * @param azureResourceName the azureResourceName value to set.
     * @return the HostnameBindingProperties object itself.
     */
    public HostnameBindingProperties withAzureResourceName(String azureResourceName) {
        this.azureResourceName = azureResourceName;
        return this;
    }

    /**
     * Get the azureResourceType property: Azure resource type.
     * 
     * @return the azureResourceType value.
     */
    public AzureResourceType azureResourceType() {
        return this.azureResourceType;
    }

    /**
     * Set the azureResourceType property: Azure resource type.
     * 
     * @param azureResourceType the azureResourceType value to set.
     * @return the HostnameBindingProperties object itself.
     */
    public HostnameBindingProperties withAzureResourceType(AzureResourceType azureResourceType) {
        this.azureResourceType = azureResourceType;
        return this;
    }

    /**
     * Get the customHostnameDnsRecordType property: Custom DNS record type.
     * 
     * @return the customHostnameDnsRecordType value.
     */
    public CustomHostnameDnsRecordType customHostnameDnsRecordType() {
        return this.customHostnameDnsRecordType;
    }

    /**
     * Set the customHostnameDnsRecordType property: Custom DNS record type.
     * 
     * @param customHostnameDnsRecordType the customHostnameDnsRecordType value to set.
     * @return the HostnameBindingProperties object itself.
     */
    public HostnameBindingProperties
        withCustomHostnameDnsRecordType(CustomHostnameDnsRecordType customHostnameDnsRecordType) {
        this.customHostnameDnsRecordType = customHostnameDnsRecordType;
        return this;
    }

    /**
     * Get the hostnameType property: Hostname type.
     * 
     * @return the hostnameType value.
     */
    public HostnameType hostnameType() {
        return this.hostnameType;
    }

    /**
     * Set the hostnameType property: Hostname type.
     * 
     * @param hostnameType the hostnameType value to set.
     * @return the HostnameBindingProperties object itself.
     */
    public HostnameBindingProperties withHostnameType(HostnameType hostnameType) {
        this.hostnameType = hostnameType;
        return this;
    }

    /**
     * Get the sslState property: SSL type.
     * 
     * @return the sslState value.
     */
    public SslState sslState() {
        return this.sslState;
    }

    /**
     * Set the sslState property: SSL type.
     * 
     * @param sslState the sslState value to set.
     * @return the HostnameBindingProperties object itself.
     */
    public HostnameBindingProperties withSslState(SslState sslState) {
        this.sslState = sslState;
        return this;
    }

    /**
     * Get the thumbprint property: SSL certificate thumbprint.
     * 
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Set the thumbprint property: SSL certificate thumbprint.
     * 
     * @param thumbprint the thumbprint value to set.
     * @return the HostnameBindingProperties object itself.
     */
    public HostnameBindingProperties withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    /**
     * Get the virtualIp property: Virtual IP address assigned to the hostname if IP based SSL is enabled.
     * 
     * @return the virtualIp value.
     */
    public String virtualIp() {
        return this.virtualIp;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("siteName", this.siteName);
        jsonWriter.writeStringField("domainId", this.domainId);
        jsonWriter.writeStringField("azureResourceName", this.azureResourceName);
        jsonWriter.writeStringField("azureResourceType",
            this.azureResourceType == null ? null : this.azureResourceType.toString());
        jsonWriter.writeStringField("customHostNameDnsRecordType",
            this.customHostnameDnsRecordType == null ? null : this.customHostnameDnsRecordType.toString());
        jsonWriter.writeStringField("hostNameType", this.hostnameType == null ? null : this.hostnameType.toString());
        jsonWriter.writeStringField("sslState", this.sslState == null ? null : this.sslState.toString());
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HostnameBindingProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HostnameBindingProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the HostnameBindingProperties.
     */
    public static HostnameBindingProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HostnameBindingProperties deserializedHostnameBindingProperties = new HostnameBindingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("siteName".equals(fieldName)) {
                    deserializedHostnameBindingProperties.siteName = reader.getString();
                } else if ("domainId".equals(fieldName)) {
                    deserializedHostnameBindingProperties.domainId = reader.getString();
                } else if ("azureResourceName".equals(fieldName)) {
                    deserializedHostnameBindingProperties.azureResourceName = reader.getString();
                } else if ("azureResourceType".equals(fieldName)) {
                    deserializedHostnameBindingProperties.azureResourceType
                        = AzureResourceType.fromString(reader.getString());
                } else if ("customHostNameDnsRecordType".equals(fieldName)) {
                    deserializedHostnameBindingProperties.customHostnameDnsRecordType
                        = CustomHostnameDnsRecordType.fromString(reader.getString());
                } else if ("hostNameType".equals(fieldName)) {
                    deserializedHostnameBindingProperties.hostnameType = HostnameType.fromString(reader.getString());
                } else if ("sslState".equals(fieldName)) {
                    deserializedHostnameBindingProperties.sslState = SslState.fromString(reader.getString());
                } else if ("thumbprint".equals(fieldName)) {
                    deserializedHostnameBindingProperties.thumbprint = reader.getString();
                } else if ("virtualIP".equals(fieldName)) {
                    deserializedHostnameBindingProperties.virtualIp = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHostnameBindingProperties;
        });
    }
}
