// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.OperationStatus;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * MySQL migration status.
 */
@Fluent
public final class MigrateMySqlStatusInner extends ProxyOnlyResource {
    /*
     * MigrateMySqlStatus resource specific properties
     */
    private MigrateMySqlStatusProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of MigrateMySqlStatusInner class.
     */
    public MigrateMySqlStatusInner() {
    }

    /**
     * Get the innerProperties property: MigrateMySqlStatus resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private MigrateMySqlStatusProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MigrateMySqlStatusInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the migrationOperationStatus property: Status of the migration task.
     * 
     * @return the migrationOperationStatus value.
     */
    public OperationStatus migrationOperationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationOperationStatus();
    }

    /**
     * Get the operationId property: Operation ID for the migration task.
     * 
     * @return the operationId value.
     */
    public String operationId() {
        return this.innerProperties() == null ? null : this.innerProperties().operationId();
    }

    /**
     * Get the localMySqlEnabled property: True if the web app has in app MySql enabled.
     * 
     * @return the localMySqlEnabled value.
     */
    public Boolean localMySqlEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().localMySqlEnabled();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrateMySqlStatusInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrateMySqlStatusInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MigrateMySqlStatusInner.
     */
    public static MigrateMySqlStatusInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrateMySqlStatusInner deserializedMigrateMySqlStatusInner = new MigrateMySqlStatusInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMigrateMySqlStatusInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMigrateMySqlStatusInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMigrateMySqlStatusInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedMigrateMySqlStatusInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedMigrateMySqlStatusInner.innerProperties = MigrateMySqlStatusProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrateMySqlStatusInner;
        });
    }
}
