// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ArmIdWrapper;
import com.azure.resourcemanager.appservice.models.PrivateLinkConnectionState;
import java.io.IOException;
import java.util.List;

/**
 * RemotePrivateEndpointConnectionARMResource resource specific properties.
 */
@Fluent
public final class RemotePrivateEndpointConnectionArmResourceProperties
    implements JsonSerializable<RemotePrivateEndpointConnectionArmResourceProperties> {
    /*
     * The provisioningState property.
     */
    private String provisioningState;

    /*
     * PrivateEndpoint of a remote private endpoint connection
     */
    private ArmIdWrapper privateEndpoint;

    /*
     * The state of a private link connection
     */
    private PrivateLinkConnectionState privateLinkServiceConnectionState;

    /*
     * Private IPAddresses mapped to the remote private endpoint
     */
    private List<String> ipAddresses;

    /**
     * Creates an instance of RemotePrivateEndpointConnectionArmResourceProperties class.
     */
    public RemotePrivateEndpointConnectionArmResourceProperties() {
    }

    /**
     * Get the provisioningState property: The provisioningState property.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the privateEndpoint property: PrivateEndpoint of a remote private endpoint connection.
     * 
     * @return the privateEndpoint value.
     */
    public ArmIdWrapper privateEndpoint() {
        return this.privateEndpoint;
    }

    /**
     * Set the privateEndpoint property: PrivateEndpoint of a remote private endpoint connection.
     * 
     * @param privateEndpoint the privateEndpoint value to set.
     * @return the RemotePrivateEndpointConnectionArmResourceProperties object itself.
     */
    public RemotePrivateEndpointConnectionArmResourceProperties withPrivateEndpoint(ArmIdWrapper privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    /**
     * Get the privateLinkServiceConnectionState property: The state of a private link connection.
     * 
     * @return the privateLinkServiceConnectionState value.
     */
    public PrivateLinkConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    /**
     * Set the privateLinkServiceConnectionState property: The state of a private link connection.
     * 
     * @param privateLinkServiceConnectionState the privateLinkServiceConnectionState value to set.
     * @return the RemotePrivateEndpointConnectionArmResourceProperties object itself.
     */
    public RemotePrivateEndpointConnectionArmResourceProperties
        withPrivateLinkServiceConnectionState(PrivateLinkConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    /**
     * Get the ipAddresses property: Private IPAddresses mapped to the remote private endpoint.
     * 
     * @return the ipAddresses value.
     */
    public List<String> ipAddresses() {
        return this.ipAddresses;
    }

    /**
     * Set the ipAddresses property: Private IPAddresses mapped to the remote private endpoint.
     * 
     * @param ipAddresses the ipAddresses value to set.
     * @return the RemotePrivateEndpointConnectionArmResourceProperties object itself.
     */
    public RemotePrivateEndpointConnectionArmResourceProperties withIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateEndpoint() != null) {
            privateEndpoint().validate();
        }
        if (privateLinkServiceConnectionState() != null) {
            privateLinkServiceConnectionState().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateEndpoint", this.privateEndpoint);
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", this.privateLinkServiceConnectionState);
        jsonWriter.writeArrayField("ipAddresses", this.ipAddresses, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RemotePrivateEndpointConnectionArmResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RemotePrivateEndpointConnectionArmResourceProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RemotePrivateEndpointConnectionArmResourceProperties.
     */
    public static RemotePrivateEndpointConnectionArmResourceProperties fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            RemotePrivateEndpointConnectionArmResourceProperties deserializedRemotePrivateEndpointConnectionArmResourceProperties
                = new RemotePrivateEndpointConnectionArmResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnectionArmResourceProperties.provisioningState
                        = reader.getString();
                } else if ("privateEndpoint".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnectionArmResourceProperties.privateEndpoint
                        = ArmIdWrapper.fromJson(reader);
                } else if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedRemotePrivateEndpointConnectionArmResourceProperties.privateLinkServiceConnectionState
                        = PrivateLinkConnectionState.fromJson(reader);
                } else if ("ipAddresses".equals(fieldName)) {
                    List<String> ipAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedRemotePrivateEndpointConnectionArmResourceProperties.ipAddresses = ipAddresses;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRemotePrivateEndpointConnectionArmResourceProperties;
        });
    }
}
