// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ComputeModeOptions;
import java.io.IOException;
import java.util.List;

/**
 * Worker pool of an App Service Environment.
 */
@Fluent
public final class WorkerPool implements JsonSerializable<WorkerPool> {
    /*
     * Worker size ID for referencing this worker pool.
     */
    private Integer workerSizeId;

    /*
     * Shared or dedicated app hosting.
     */
    private ComputeModeOptions computeMode;

    /*
     * VM size of the worker pool instances.
     */
    private String workerSize;

    /*
     * Number of instances in the worker pool.
     */
    private Integer workerCount;

    /*
     * Names of all instances in the worker pool (read only).
     */
    private List<String> instanceNames;

    /**
     * Creates an instance of WorkerPool class.
     */
    public WorkerPool() {
    }

    /**
     * Get the workerSizeId property: Worker size ID for referencing this worker pool.
     * 
     * @return the workerSizeId value.
     */
    public Integer workerSizeId() {
        return this.workerSizeId;
    }

    /**
     * Set the workerSizeId property: Worker size ID for referencing this worker pool.
     * 
     * @param workerSizeId the workerSizeId value to set.
     * @return the WorkerPool object itself.
     */
    public WorkerPool withWorkerSizeId(Integer workerSizeId) {
        this.workerSizeId = workerSizeId;
        return this;
    }

    /**
     * Get the computeMode property: Shared or dedicated app hosting.
     * 
     * @return the computeMode value.
     */
    public ComputeModeOptions computeMode() {
        return this.computeMode;
    }

    /**
     * Set the computeMode property: Shared or dedicated app hosting.
     * 
     * @param computeMode the computeMode value to set.
     * @return the WorkerPool object itself.
     */
    public WorkerPool withComputeMode(ComputeModeOptions computeMode) {
        this.computeMode = computeMode;
        return this;
    }

    /**
     * Get the workerSize property: VM size of the worker pool instances.
     * 
     * @return the workerSize value.
     */
    public String workerSize() {
        return this.workerSize;
    }

    /**
     * Set the workerSize property: VM size of the worker pool instances.
     * 
     * @param workerSize the workerSize value to set.
     * @return the WorkerPool object itself.
     */
    public WorkerPool withWorkerSize(String workerSize) {
        this.workerSize = workerSize;
        return this;
    }

    /**
     * Get the workerCount property: Number of instances in the worker pool.
     * 
     * @return the workerCount value.
     */
    public Integer workerCount() {
        return this.workerCount;
    }

    /**
     * Set the workerCount property: Number of instances in the worker pool.
     * 
     * @param workerCount the workerCount value to set.
     * @return the WorkerPool object itself.
     */
    public WorkerPool withWorkerCount(Integer workerCount) {
        this.workerCount = workerCount;
        return this;
    }

    /**
     * Get the instanceNames property: Names of all instances in the worker pool (read only).
     * 
     * @return the instanceNames value.
     */
    public List<String> instanceNames() {
        return this.instanceNames;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("workerSizeId", this.workerSizeId);
        jsonWriter.writeStringField("computeMode", this.computeMode == null ? null : this.computeMode.toString());
        jsonWriter.writeStringField("workerSize", this.workerSize);
        jsonWriter.writeNumberField("workerCount", this.workerCount);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkerPool from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkerPool if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the WorkerPool.
     */
    public static WorkerPool fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkerPool deserializedWorkerPool = new WorkerPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("workerSizeId".equals(fieldName)) {
                    deserializedWorkerPool.workerSizeId = reader.getNullable(JsonReader::getInt);
                } else if ("computeMode".equals(fieldName)) {
                    deserializedWorkerPool.computeMode = ComputeModeOptions.fromString(reader.getString());
                } else if ("workerSize".equals(fieldName)) {
                    deserializedWorkerPool.workerSize = reader.getString();
                } else if ("workerCount".equals(fieldName)) {
                    deserializedWorkerPool.workerCount = reader.getNullable(JsonReader::getInt);
                } else if ("instanceNames".equals(fieldName)) {
                    List<String> instanceNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedWorkerPool.instanceNames = instanceNames;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkerPool;
        });
    }
}
