// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Rules that can be defined for auto-heal.
 */
@Fluent
public final class AutoHealRules implements JsonSerializable<AutoHealRules> {
    /*
     * Conditions that describe when to execute the auto-heal actions.
     */
    private AutoHealTriggers triggers;

    /*
     * Actions to be executed when a rule is triggered.
     */
    private AutoHealActions actions;

    /**
     * Creates an instance of AutoHealRules class.
     */
    public AutoHealRules() {
    }

    /**
     * Get the triggers property: Conditions that describe when to execute the auto-heal actions.
     * 
     * @return the triggers value.
     */
    public AutoHealTriggers triggers() {
        return this.triggers;
    }

    /**
     * Set the triggers property: Conditions that describe when to execute the auto-heal actions.
     * 
     * @param triggers the triggers value to set.
     * @return the AutoHealRules object itself.
     */
    public AutoHealRules withTriggers(AutoHealTriggers triggers) {
        this.triggers = triggers;
        return this;
    }

    /**
     * Get the actions property: Actions to be executed when a rule is triggered.
     * 
     * @return the actions value.
     */
    public AutoHealActions actions() {
        return this.actions;
    }

    /**
     * Set the actions property: Actions to be executed when a rule is triggered.
     * 
     * @param actions the actions value to set.
     * @return the AutoHealRules object itself.
     */
    public AutoHealRules withActions(AutoHealActions actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (triggers() != null) {
            triggers().validate();
        }
        if (actions() != null) {
            actions().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("triggers", this.triggers);
        jsonWriter.writeJsonField("actions", this.actions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoHealRules from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoHealRules if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AutoHealRules.
     */
    public static AutoHealRules fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoHealRules deserializedAutoHealRules = new AutoHealRules();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("triggers".equals(fieldName)) {
                    deserializedAutoHealRules.triggers = AutoHealTriggers.fromJson(reader);
                } else if ("actions".equals(fieldName)) {
                    deserializedAutoHealRules.actions = AutoHealActions.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoHealRules;
        });
    }
}
