// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The CertificateOrderContact model.
 */
@Fluent
public final class CertificateOrderContact implements JsonSerializable<CertificateOrderContact> {
    /*
     * The email property.
     */
    private String email;

    /*
     * The nameFirst property.
     */
    private String nameFirst;

    /*
     * The nameLast property.
     */
    private String nameLast;

    /*
     * The phone property.
     */
    private String phone;

    /**
     * Creates an instance of CertificateOrderContact class.
     */
    public CertificateOrderContact() {
    }

    /**
     * Get the email property: The email property.
     * 
     * @return the email value.
     */
    public String email() {
        return this.email;
    }

    /**
     * Set the email property: The email property.
     * 
     * @param email the email value to set.
     * @return the CertificateOrderContact object itself.
     */
    public CertificateOrderContact withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Get the nameFirst property: The nameFirst property.
     * 
     * @return the nameFirst value.
     */
    public String nameFirst() {
        return this.nameFirst;
    }

    /**
     * Set the nameFirst property: The nameFirst property.
     * 
     * @param nameFirst the nameFirst value to set.
     * @return the CertificateOrderContact object itself.
     */
    public CertificateOrderContact withNameFirst(String nameFirst) {
        this.nameFirst = nameFirst;
        return this;
    }

    /**
     * Get the nameLast property: The nameLast property.
     * 
     * @return the nameLast value.
     */
    public String nameLast() {
        return this.nameLast;
    }

    /**
     * Set the nameLast property: The nameLast property.
     * 
     * @param nameLast the nameLast value to set.
     * @return the CertificateOrderContact object itself.
     */
    public CertificateOrderContact withNameLast(String nameLast) {
        this.nameLast = nameLast;
        return this;
    }

    /**
     * Get the phone property: The phone property.
     * 
     * @return the phone value.
     */
    public String phone() {
        return this.phone;
    }

    /**
     * Set the phone property: The phone property.
     * 
     * @param phone the phone value to set.
     * @return the CertificateOrderContact object itself.
     */
    public CertificateOrderContact withPhone(String phone) {
        this.phone = phone;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeStringField("nameFirst", this.nameFirst);
        jsonWriter.writeStringField("nameLast", this.nameLast);
        jsonWriter.writeStringField("phone", this.phone);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateOrderContact from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateOrderContact if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateOrderContact.
     */
    public static CertificateOrderContact fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateOrderContact deserializedCertificateOrderContact = new CertificateOrderContact();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("email".equals(fieldName)) {
                    deserializedCertificateOrderContact.email = reader.getString();
                } else if ("nameFirst".equals(fieldName)) {
                    deserializedCertificateOrderContact.nameFirst = reader.getString();
                } else if ("nameLast".equals(fieldName)) {
                    deserializedCertificateOrderContact.nameLast = reader.getString();
                } else if ("phone".equals(fieldName)) {
                    deserializedCertificateOrderContact.phone = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateOrderContact;
        });
    }
}
