// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ContainerAppsConfiguration model.
 */
@Fluent
public final class ContainerAppsConfiguration implements JsonSerializable<ContainerAppsConfiguration> {
    /*
     * Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
     */
    private String daprAIInstrumentationKey;

    /*
     * IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. It must not overlap
     * with any other Subnet IP ranges.
     */
    private String platformReservedCidr;

    /*
     * An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server
     */
    private String platformReservedDnsIp;

    /*
     * Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the
     * subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if
     * defined.
     */
    private String controlPlaneSubnetResourceId;

    /*
     * Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the
     * subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if
     * defined.
     */
    private String appSubnetResourceId;

    /*
     * CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or
     * the IP range defined in platformReservedCidr, if defined.
     */
    private String dockerBridgeCidr;

    /**
     * Creates an instance of ContainerAppsConfiguration class.
     */
    public ContainerAppsConfiguration() {
    }

    /**
     * Get the daprAIInstrumentationKey property: Azure Monitor instrumentation key used by Dapr to export Service to
     * Service communication telemetry.
     * 
     * @return the daprAIInstrumentationKey value.
     */
    public String daprAIInstrumentationKey() {
        return this.daprAIInstrumentationKey;
    }

    /**
     * Set the daprAIInstrumentationKey property: Azure Monitor instrumentation key used by Dapr to export Service to
     * Service communication telemetry.
     * 
     * @param daprAIInstrumentationKey the daprAIInstrumentationKey value to set.
     * @return the ContainerAppsConfiguration object itself.
     */
    public ContainerAppsConfiguration withDaprAIInstrumentationKey(String daprAIInstrumentationKey) {
        this.daprAIInstrumentationKey = daprAIInstrumentationKey;
        return this;
    }

    /**
     * Get the platformReservedCidr property: IP range in CIDR notation that can be reserved for environment
     * infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
     * 
     * @return the platformReservedCidr value.
     */
    public String platformReservedCidr() {
        return this.platformReservedCidr;
    }

    /**
     * Set the platformReservedCidr property: IP range in CIDR notation that can be reserved for environment
     * infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
     * 
     * @param platformReservedCidr the platformReservedCidr value to set.
     * @return the ContainerAppsConfiguration object itself.
     */
    public ContainerAppsConfiguration withPlatformReservedCidr(String platformReservedCidr) {
        this.platformReservedCidr = platformReservedCidr;
        return this;
    }

    /**
     * Get the platformReservedDnsIp property: An IP address from the IP range defined by platformReservedCidr that will
     * be reserved for the internal DNS server.
     * 
     * @return the platformReservedDnsIp value.
     */
    public String platformReservedDnsIp() {
        return this.platformReservedDnsIp;
    }

    /**
     * Set the platformReservedDnsIp property: An IP address from the IP range defined by platformReservedCidr that will
     * be reserved for the internal DNS server.
     * 
     * @param platformReservedDnsIp the platformReservedDnsIp value to set.
     * @return the ContainerAppsConfiguration object itself.
     */
    public ContainerAppsConfiguration withPlatformReservedDnsIp(String platformReservedDnsIp) {
        this.platformReservedDnsIp = platformReservedDnsIp;
        return this;
    }

    /**
     * Get the controlPlaneSubnetResourceId property: Resource ID of a subnet for control plane infrastructure
     * components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap
     * with the IP range defined in platformReservedCidr, if defined.
     * 
     * @return the controlPlaneSubnetResourceId value.
     */
    public String controlPlaneSubnetResourceId() {
        return this.controlPlaneSubnetResourceId;
    }

    /**
     * Set the controlPlaneSubnetResourceId property: Resource ID of a subnet for control plane infrastructure
     * components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap
     * with the IP range defined in platformReservedCidr, if defined.
     * 
     * @param controlPlaneSubnetResourceId the controlPlaneSubnetResourceId value to set.
     * @return the ContainerAppsConfiguration object itself.
     */
    public ContainerAppsConfiguration withControlPlaneSubnetResourceId(String controlPlaneSubnetResourceId) {
        this.controlPlaneSubnetResourceId = controlPlaneSubnetResourceId;
        return this;
    }

    /**
     * Get the appSubnetResourceId property: Resource ID of a subnet for control plane infrastructure components. This
     * subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range
     * defined in platformReservedCidr, if defined.
     * 
     * @return the appSubnetResourceId value.
     */
    public String appSubnetResourceId() {
        return this.appSubnetResourceId;
    }

    /**
     * Set the appSubnetResourceId property: Resource ID of a subnet for control plane infrastructure components. This
     * subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range
     * defined in platformReservedCidr, if defined.
     * 
     * @param appSubnetResourceId the appSubnetResourceId value to set.
     * @return the ContainerAppsConfiguration object itself.
     */
    public ContainerAppsConfiguration withAppSubnetResourceId(String appSubnetResourceId) {
        this.appSubnetResourceId = appSubnetResourceId;
        return this;
    }

    /**
     * Get the dockerBridgeCidr property: CIDR notation IP range assigned to the Docker bridge network. It must not
     * overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if defined.
     * 
     * @return the dockerBridgeCidr value.
     */
    public String dockerBridgeCidr() {
        return this.dockerBridgeCidr;
    }

    /**
     * Set the dockerBridgeCidr property: CIDR notation IP range assigned to the Docker bridge network. It must not
     * overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if defined.
     * 
     * @param dockerBridgeCidr the dockerBridgeCidr value to set.
     * @return the ContainerAppsConfiguration object itself.
     */
    public ContainerAppsConfiguration withDockerBridgeCidr(String dockerBridgeCidr) {
        this.dockerBridgeCidr = dockerBridgeCidr;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("daprAIInstrumentationKey", this.daprAIInstrumentationKey);
        jsonWriter.writeStringField("platformReservedCidr", this.platformReservedCidr);
        jsonWriter.writeStringField("platformReservedDnsIP", this.platformReservedDnsIp);
        jsonWriter.writeStringField("controlPlaneSubnetResourceId", this.controlPlaneSubnetResourceId);
        jsonWriter.writeStringField("appSubnetResourceId", this.appSubnetResourceId);
        jsonWriter.writeStringField("dockerBridgeCidr", this.dockerBridgeCidr);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerAppsConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerAppsConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerAppsConfiguration.
     */
    public static ContainerAppsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerAppsConfiguration deserializedContainerAppsConfiguration = new ContainerAppsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("daprAIInstrumentationKey".equals(fieldName)) {
                    deserializedContainerAppsConfiguration.daprAIInstrumentationKey = reader.getString();
                } else if ("platformReservedCidr".equals(fieldName)) {
                    deserializedContainerAppsConfiguration.platformReservedCidr = reader.getString();
                } else if ("platformReservedDnsIP".equals(fieldName)) {
                    deserializedContainerAppsConfiguration.platformReservedDnsIp = reader.getString();
                } else if ("controlPlaneSubnetResourceId".equals(fieldName)) {
                    deserializedContainerAppsConfiguration.controlPlaneSubnetResourceId = reader.getString();
                } else if ("appSubnetResourceId".equals(fieldName)) {
                    deserializedContainerAppsConfiguration.appSubnetResourceId = reader.getString();
                } else if ("dockerBridgeCidr".equals(fieldName)) {
                    deserializedContainerAppsConfiguration.dockerBridgeCidr = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerAppsConfiguration;
        });
    }
}
