// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * SSL-enabled hostname.
 */
@Fluent
public final class HostnameSslState implements JsonSerializable<HostnameSslState> {
    /*
     * Hostname.
     */
    private String name;

    /*
     * SSL type.
     */
    private SslState sslState;

    /*
     * Virtual IP address assigned to the hostname if IP based SSL is enabled.
     */
    private String virtualIp;

    /*
     * SSL certificate thumbprint.
     */
    private String thumbprint;

    /*
     * Set to <code>true</code> to update existing hostname.
     */
    private Boolean toUpdate;

    /*
     * Indicates whether the hostname is a standard or repository hostname.
     */
    private HostType hostType;

    /**
     * Creates an instance of HostnameSslState class.
     */
    public HostnameSslState() {
    }

    /**
     * Get the name property: Hostname.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Hostname.
     * 
     * @param name the name value to set.
     * @return the HostnameSslState object itself.
     */
    public HostnameSslState withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the sslState property: SSL type.
     * 
     * @return the sslState value.
     */
    public SslState sslState() {
        return this.sslState;
    }

    /**
     * Set the sslState property: SSL type.
     * 
     * @param sslState the sslState value to set.
     * @return the HostnameSslState object itself.
     */
    public HostnameSslState withSslState(SslState sslState) {
        this.sslState = sslState;
        return this;
    }

    /**
     * Get the virtualIp property: Virtual IP address assigned to the hostname if IP based SSL is enabled.
     * 
     * @return the virtualIp value.
     */
    public String virtualIp() {
        return this.virtualIp;
    }

    /**
     * Set the virtualIp property: Virtual IP address assigned to the hostname if IP based SSL is enabled.
     * 
     * @param virtualIp the virtualIp value to set.
     * @return the HostnameSslState object itself.
     */
    public HostnameSslState withVirtualIp(String virtualIp) {
        this.virtualIp = virtualIp;
        return this;
    }

    /**
     * Get the thumbprint property: SSL certificate thumbprint.
     * 
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Set the thumbprint property: SSL certificate thumbprint.
     * 
     * @param thumbprint the thumbprint value to set.
     * @return the HostnameSslState object itself.
     */
    public HostnameSslState withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    /**
     * Get the toUpdate property: Set to &lt;code&gt;true&lt;/code&gt; to update existing hostname.
     * 
     * @return the toUpdate value.
     */
    public Boolean toUpdate() {
        return this.toUpdate;
    }

    /**
     * Set the toUpdate property: Set to &lt;code&gt;true&lt;/code&gt; to update existing hostname.
     * 
     * @param toUpdate the toUpdate value to set.
     * @return the HostnameSslState object itself.
     */
    public HostnameSslState withToUpdate(Boolean toUpdate) {
        this.toUpdate = toUpdate;
        return this;
    }

    /**
     * Get the hostType property: Indicates whether the hostname is a standard or repository hostname.
     * 
     * @return the hostType value.
     */
    public HostType hostType() {
        return this.hostType;
    }

    /**
     * Set the hostType property: Indicates whether the hostname is a standard or repository hostname.
     * 
     * @param hostType the hostType value to set.
     * @return the HostnameSslState object itself.
     */
    public HostnameSslState withHostType(HostType hostType) {
        this.hostType = hostType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("sslState", this.sslState == null ? null : this.sslState.toString());
        jsonWriter.writeStringField("virtualIP", this.virtualIp);
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        jsonWriter.writeBooleanField("toUpdate", this.toUpdate);
        jsonWriter.writeStringField("hostType", this.hostType == null ? null : this.hostType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HostnameSslState from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HostnameSslState if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HostnameSslState.
     */
    public static HostnameSslState fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HostnameSslState deserializedHostnameSslState = new HostnameSslState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedHostnameSslState.name = reader.getString();
                } else if ("sslState".equals(fieldName)) {
                    deserializedHostnameSslState.sslState = SslState.fromString(reader.getString());
                } else if ("virtualIP".equals(fieldName)) {
                    deserializedHostnameSslState.virtualIp = reader.getString();
                } else if ("thumbprint".equals(fieldName)) {
                    deserializedHostnameSslState.thumbprint = reader.getString();
                } else if ("toUpdate".equals(fieldName)) {
                    deserializedHostnameSslState.toUpdate = reader.getNullable(JsonReader::getBoolean);
                } else if ("hostType".equals(fieldName)) {
                    deserializedHostnameSslState.hostType = HostType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHostnameSslState;
        });
    }
}
