// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the paths HTTP requests.
 */
@Fluent
public final class HttpSettingsRoutes implements JsonSerializable<HttpSettingsRoutes> {
    /*
     * The prefix that should precede all the authentication/authorization paths.
     */
    private String apiPrefix;

    /**
     * Creates an instance of HttpSettingsRoutes class.
     */
    public HttpSettingsRoutes() {
    }

    /**
     * Get the apiPrefix property: The prefix that should precede all the authentication/authorization paths.
     * 
     * @return the apiPrefix value.
     */
    public String apiPrefix() {
        return this.apiPrefix;
    }

    /**
     * Set the apiPrefix property: The prefix that should precede all the authentication/authorization paths.
     * 
     * @param apiPrefix the apiPrefix value to set.
     * @return the HttpSettingsRoutes object itself.
     */
    public HttpSettingsRoutes withApiPrefix(String apiPrefix) {
        this.apiPrefix = apiPrefix;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("apiPrefix", this.apiPrefix);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HttpSettingsRoutes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HttpSettingsRoutes if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HttpSettingsRoutes.
     */
    public static HttpSettingsRoutes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpSettingsRoutes deserializedHttpSettingsRoutes = new HttpSettingsRoutes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("apiPrefix".equals(fieldName)) {
                    deserializedHttpSettingsRoutes.apiPrefix = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHttpSettingsRoutes;
        });
    }
}
