// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Site seal request.
 */
@Fluent
public final class SiteSealRequest implements JsonSerializable<SiteSealRequest> {
    /*
     * If <code>true</code> use the light color theme for site seal; otherwise, use the default color theme.
     */
    private Boolean lightTheme;

    /*
     * Locale of site seal.
     */
    private String locale;

    /**
     * Creates an instance of SiteSealRequest class.
     */
    public SiteSealRequest() {
    }

    /**
     * Get the lightTheme property: If &lt;code&gt;true&lt;/code&gt; use the light color theme for site seal; otherwise,
     * use the default color theme.
     * 
     * @return the lightTheme value.
     */
    public Boolean lightTheme() {
        return this.lightTheme;
    }

    /**
     * Set the lightTheme property: If &lt;code&gt;true&lt;/code&gt; use the light color theme for site seal; otherwise,
     * use the default color theme.
     * 
     * @param lightTheme the lightTheme value to set.
     * @return the SiteSealRequest object itself.
     */
    public SiteSealRequest withLightTheme(Boolean lightTheme) {
        this.lightTheme = lightTheme;
        return this;
    }

    /**
     * Get the locale property: Locale of site seal.
     * 
     * @return the locale value.
     */
    public String locale() {
        return this.locale;
    }

    /**
     * Set the locale property: Locale of site seal.
     * 
     * @param locale the locale value to set.
     * @return the SiteSealRequest object itself.
     */
    public SiteSealRequest withLocale(String locale) {
        this.locale = locale;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("lightTheme", this.lightTheme);
        jsonWriter.writeStringField("locale", this.locale);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteSealRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteSealRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SiteSealRequest.
     */
    public static SiteSealRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteSealRequest deserializedSiteSealRequest = new SiteSealRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("lightTheme".equals(fieldName)) {
                    deserializedSiteSealRequest.lightTheme = reader.getNullable(JsonReader::getBoolean);
                } else if ("locale".equals(fieldName)) {
                    deserializedSiteSealRequest.locale = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteSealRequest;
        });
    }
}
