// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the app registration for the Twitter provider.
 */
@Fluent
public final class TwitterRegistration implements JsonSerializable<TwitterRegistration> {
    /*
     * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
     * This setting is required for enabling Twitter Sign-In.
     * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
     */
    private String consumerKey;

    /*
     * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
     * application used for sign-in.
     */
    private String consumerSecretSettingName;

    /**
     * Creates an instance of TwitterRegistration class.
     */
    public TwitterRegistration() {
    }

    /**
     * Get the consumerKey property: The OAuth 1.0a consumer key of the Twitter application used for sign-in.
     * This setting is required for enabling Twitter Sign-In.
     * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
     * 
     * @return the consumerKey value.
     */
    public String consumerKey() {
        return this.consumerKey;
    }

    /**
     * Set the consumerKey property: The OAuth 1.0a consumer key of the Twitter application used for sign-in.
     * This setting is required for enabling Twitter Sign-In.
     * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
     * 
     * @param consumerKey the consumerKey value to set.
     * @return the TwitterRegistration object itself.
     */
    public TwitterRegistration withConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    /**
     * Get the consumerSecretSettingName property: The app setting name that contains the OAuth 1.0a consumer secret of
     * the Twitter
     * application used for sign-in.
     * 
     * @return the consumerSecretSettingName value.
     */
    public String consumerSecretSettingName() {
        return this.consumerSecretSettingName;
    }

    /**
     * Set the consumerSecretSettingName property: The app setting name that contains the OAuth 1.0a consumer secret of
     * the Twitter
     * application used for sign-in.
     * 
     * @param consumerSecretSettingName the consumerSecretSettingName value to set.
     * @return the TwitterRegistration object itself.
     */
    public TwitterRegistration withConsumerSecretSettingName(String consumerSecretSettingName) {
        this.consumerSecretSettingName = consumerSecretSettingName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("consumerKey", this.consumerKey);
        jsonWriter.writeStringField("consumerSecretSettingName", this.consumerSecretSettingName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TwitterRegistration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TwitterRegistration if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TwitterRegistration.
     */
    public static TwitterRegistration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TwitterRegistration deserializedTwitterRegistration = new TwitterRegistration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("consumerKey".equals(fieldName)) {
                    deserializedTwitterRegistration.consumerKey = reader.getString();
                } else if ("consumerSecretSettingName".equals(fieldName)) {
                    deserializedTwitterRegistration.consumerSecretSettingName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTwitterRegistration;
        });
    }
}
