/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.PushSettingsInner;
import com.azure.resourcemanager.appservice.models.ApiDefinitionInfo;
import com.azure.resourcemanager.appservice.models.ApiManagementConfig;
import com.azure.resourcemanager.appservice.models.AutoHealRules;
import com.azure.resourcemanager.appservice.models.AzureStorageInfoValue;
import com.azure.resourcemanager.appservice.models.ConnStringInfo;
import com.azure.resourcemanager.appservice.models.CorsSettings;
import com.azure.resourcemanager.appservice.models.DefaultAction;
import com.azure.resourcemanager.appservice.models.Experiments;
import com.azure.resourcemanager.appservice.models.FtpsState;
import com.azure.resourcemanager.appservice.models.HandlerMapping;
import com.azure.resourcemanager.appservice.models.IpSecurityRestriction;
import com.azure.resourcemanager.appservice.models.ManagedPipelineMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ScmType;
import com.azure.resourcemanager.appservice.models.SiteLimits;
import com.azure.resourcemanager.appservice.models.SiteLoadBalancing;
import com.azure.resourcemanager.appservice.models.SiteMachineKey;
import com.azure.resourcemanager.appservice.models.SupportedTlsVersions;
import com.azure.resourcemanager.appservice.models.TlsCipherSuites;
import com.azure.resourcemanager.appservice.models.VirtualApplication;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class SiteConfigInner
implements JsonSerializable<SiteConfigInner> {
    private Integer numberOfWorkers;
    private List<String> defaultDocuments;
    private String netFrameworkVersion;
    private String phpVersion;
    private String pythonVersion;
    private String nodeVersion;
    private String powerShellVersion;
    private String linuxFxVersion;
    private String windowsFxVersion;
    private Boolean requestTracingEnabled;
    private OffsetDateTime requestTracingExpirationTime;
    private Boolean remoteDebuggingEnabled;
    private String remoteDebuggingVersion;
    private Boolean httpLoggingEnabled;
    private Boolean acrUseManagedIdentityCreds;
    private String acrUserManagedIdentityId;
    private Integer logsDirectorySizeLimit;
    private Boolean detailedErrorLoggingEnabled;
    private String publishingUsername;
    private List<NameValuePair> appSettings;
    private List<NameValuePair> metadata;
    private List<ConnStringInfo> connectionStrings;
    private SiteMachineKey machineKey;
    private List<HandlerMapping> handlerMappings;
    private String documentRoot;
    private ScmType scmType;
    private Boolean use32BitWorkerProcess;
    private Boolean webSocketsEnabled;
    private Boolean alwaysOn;
    private String javaVersion;
    private String javaContainer;
    private String javaContainerVersion;
    private String appCommandLine;
    private ManagedPipelineMode managedPipelineMode;
    private List<VirtualApplication> virtualApplications;
    private SiteLoadBalancing loadBalancing;
    private Experiments experiments;
    private SiteLimits limits;
    private Boolean autoHealEnabled;
    private AutoHealRules autoHealRules;
    private String tracingOptions;
    private String vnetName;
    private Boolean vnetRouteAllEnabled;
    private Integer vnetPrivatePortsCount;
    private CorsSettings cors;
    private PushSettingsInner push;
    private ApiDefinitionInfo apiDefinition;
    private ApiManagementConfig apiManagementConfig;
    private String autoSwapSlotName;
    private Boolean localMySqlEnabled;
    private Integer managedServiceIdentityId;
    private Integer xManagedServiceIdentityId;
    private String keyVaultReferenceIdentity;
    private List<IpSecurityRestriction> ipSecurityRestrictions;
    private DefaultAction ipSecurityRestrictionsDefaultAction;
    private List<IpSecurityRestriction> scmIpSecurityRestrictions;
    private DefaultAction scmIpSecurityRestrictionsDefaultAction;
    private Boolean scmIpSecurityRestrictionsUseMain;
    private Boolean http20Enabled;
    private SupportedTlsVersions minTlsVersion;
    private TlsCipherSuites minTlsCipherSuite;
    private SupportedTlsVersions scmMinTlsVersion;
    private FtpsState ftpsState;
    private Integer preWarmedInstanceCount;
    private Integer functionAppScaleLimit;
    private Integer elasticWebAppScaleLimit;
    private String healthCheckPath;
    private Boolean functionsRuntimeScaleMonitoringEnabled;
    private String websiteTimeZone;
    private Integer minimumElasticInstanceCount;
    private Map<String, AzureStorageInfoValue> azureStorageAccounts;
    private String publicNetworkAccess;

    public Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public SiteConfigInner withNumberOfWorkers(Integer numberOfWorkers) {
        this.numberOfWorkers = numberOfWorkers;
        return this;
    }

    public List<String> defaultDocuments() {
        return this.defaultDocuments;
    }

    public SiteConfigInner withDefaultDocuments(List<String> defaultDocuments) {
        this.defaultDocuments = defaultDocuments;
        return this;
    }

    public String netFrameworkVersion() {
        return this.netFrameworkVersion;
    }

    public SiteConfigInner withNetFrameworkVersion(String netFrameworkVersion) {
        this.netFrameworkVersion = netFrameworkVersion;
        return this;
    }

    public String phpVersion() {
        return this.phpVersion;
    }

    public SiteConfigInner withPhpVersion(String phpVersion) {
        this.phpVersion = phpVersion;
        return this;
    }

    public String pythonVersion() {
        return this.pythonVersion;
    }

    public SiteConfigInner withPythonVersion(String pythonVersion) {
        this.pythonVersion = pythonVersion;
        return this;
    }

    public String nodeVersion() {
        return this.nodeVersion;
    }

    public SiteConfigInner withNodeVersion(String nodeVersion) {
        this.nodeVersion = nodeVersion;
        return this;
    }

    public String powerShellVersion() {
        return this.powerShellVersion;
    }

    public SiteConfigInner withPowerShellVersion(String powerShellVersion) {
        this.powerShellVersion = powerShellVersion;
        return this;
    }

    public String linuxFxVersion() {
        return this.linuxFxVersion;
    }

    public SiteConfigInner withLinuxFxVersion(String linuxFxVersion) {
        this.linuxFxVersion = linuxFxVersion;
        return this;
    }

    public String windowsFxVersion() {
        return this.windowsFxVersion;
    }

    public SiteConfigInner withWindowsFxVersion(String windowsFxVersion) {
        this.windowsFxVersion = windowsFxVersion;
        return this;
    }

    public Boolean requestTracingEnabled() {
        return this.requestTracingEnabled;
    }

    public SiteConfigInner withRequestTracingEnabled(Boolean requestTracingEnabled) {
        this.requestTracingEnabled = requestTracingEnabled;
        return this;
    }

    public OffsetDateTime requestTracingExpirationTime() {
        return this.requestTracingExpirationTime;
    }

    public SiteConfigInner withRequestTracingExpirationTime(OffsetDateTime requestTracingExpirationTime) {
        this.requestTracingExpirationTime = requestTracingExpirationTime;
        return this;
    }

    public Boolean remoteDebuggingEnabled() {
        return this.remoteDebuggingEnabled;
    }

    public SiteConfigInner withRemoteDebuggingEnabled(Boolean remoteDebuggingEnabled) {
        this.remoteDebuggingEnabled = remoteDebuggingEnabled;
        return this;
    }

    public String remoteDebuggingVersion() {
        return this.remoteDebuggingVersion;
    }

    public SiteConfigInner withRemoteDebuggingVersion(String remoteDebuggingVersion) {
        this.remoteDebuggingVersion = remoteDebuggingVersion;
        return this;
    }

    public Boolean httpLoggingEnabled() {
        return this.httpLoggingEnabled;
    }

    public SiteConfigInner withHttpLoggingEnabled(Boolean httpLoggingEnabled) {
        this.httpLoggingEnabled = httpLoggingEnabled;
        return this;
    }

    public Boolean acrUseManagedIdentityCreds() {
        return this.acrUseManagedIdentityCreds;
    }

    public SiteConfigInner withAcrUseManagedIdentityCreds(Boolean acrUseManagedIdentityCreds) {
        this.acrUseManagedIdentityCreds = acrUseManagedIdentityCreds;
        return this;
    }

    public String acrUserManagedIdentityId() {
        return this.acrUserManagedIdentityId;
    }

    public SiteConfigInner withAcrUserManagedIdentityId(String acrUserManagedIdentityId) {
        this.acrUserManagedIdentityId = acrUserManagedIdentityId;
        return this;
    }

    public Integer logsDirectorySizeLimit() {
        return this.logsDirectorySizeLimit;
    }

    public SiteConfigInner withLogsDirectorySizeLimit(Integer logsDirectorySizeLimit) {
        this.logsDirectorySizeLimit = logsDirectorySizeLimit;
        return this;
    }

    public Boolean detailedErrorLoggingEnabled() {
        return this.detailedErrorLoggingEnabled;
    }

    public SiteConfigInner withDetailedErrorLoggingEnabled(Boolean detailedErrorLoggingEnabled) {
        this.detailedErrorLoggingEnabled = detailedErrorLoggingEnabled;
        return this;
    }

    public String publishingUsername() {
        return this.publishingUsername;
    }

    public SiteConfigInner withPublishingUsername(String publishingUsername) {
        this.publishingUsername = publishingUsername;
        return this;
    }

    public List<NameValuePair> appSettings() {
        return this.appSettings;
    }

    public SiteConfigInner withAppSettings(List<NameValuePair> appSettings) {
        this.appSettings = appSettings;
        return this;
    }

    public List<NameValuePair> metadata() {
        return this.metadata;
    }

    public SiteConfigInner withMetadata(List<NameValuePair> metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<ConnStringInfo> connectionStrings() {
        return this.connectionStrings;
    }

    public SiteConfigInner withConnectionStrings(List<ConnStringInfo> connectionStrings) {
        this.connectionStrings = connectionStrings;
        return this;
    }

    public SiteMachineKey machineKey() {
        return this.machineKey;
    }

    public List<HandlerMapping> handlerMappings() {
        return this.handlerMappings;
    }

    public SiteConfigInner withHandlerMappings(List<HandlerMapping> handlerMappings) {
        this.handlerMappings = handlerMappings;
        return this;
    }

    public String documentRoot() {
        return this.documentRoot;
    }

    public SiteConfigInner withDocumentRoot(String documentRoot) {
        this.documentRoot = documentRoot;
        return this;
    }

    public ScmType scmType() {
        return this.scmType;
    }

    public SiteConfigInner withScmType(ScmType scmType) {
        this.scmType = scmType;
        return this;
    }

    public Boolean use32BitWorkerProcess() {
        return this.use32BitWorkerProcess;
    }

    public SiteConfigInner withUse32BitWorkerProcess(Boolean use32BitWorkerProcess) {
        this.use32BitWorkerProcess = use32BitWorkerProcess;
        return this;
    }

    public Boolean webSocketsEnabled() {
        return this.webSocketsEnabled;
    }

    public SiteConfigInner withWebSocketsEnabled(Boolean webSocketsEnabled) {
        this.webSocketsEnabled = webSocketsEnabled;
        return this;
    }

    public Boolean alwaysOn() {
        return this.alwaysOn;
    }

    public SiteConfigInner withAlwaysOn(Boolean alwaysOn) {
        this.alwaysOn = alwaysOn;
        return this;
    }

    public String javaVersion() {
        return this.javaVersion;
    }

    public SiteConfigInner withJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
        return this;
    }

    public String javaContainer() {
        return this.javaContainer;
    }

    public SiteConfigInner withJavaContainer(String javaContainer) {
        this.javaContainer = javaContainer;
        return this;
    }

    public String javaContainerVersion() {
        return this.javaContainerVersion;
    }

    public SiteConfigInner withJavaContainerVersion(String javaContainerVersion) {
        this.javaContainerVersion = javaContainerVersion;
        return this;
    }

    public String appCommandLine() {
        return this.appCommandLine;
    }

    public SiteConfigInner withAppCommandLine(String appCommandLine) {
        this.appCommandLine = appCommandLine;
        return this;
    }

    public ManagedPipelineMode managedPipelineMode() {
        return this.managedPipelineMode;
    }

    public SiteConfigInner withManagedPipelineMode(ManagedPipelineMode managedPipelineMode) {
        this.managedPipelineMode = managedPipelineMode;
        return this;
    }

    public List<VirtualApplication> virtualApplications() {
        return this.virtualApplications;
    }

    public SiteConfigInner withVirtualApplications(List<VirtualApplication> virtualApplications) {
        this.virtualApplications = virtualApplications;
        return this;
    }

    public SiteLoadBalancing loadBalancing() {
        return this.loadBalancing;
    }

    public SiteConfigInner withLoadBalancing(SiteLoadBalancing loadBalancing) {
        this.loadBalancing = loadBalancing;
        return this;
    }

    public Experiments experiments() {
        return this.experiments;
    }

    public SiteConfigInner withExperiments(Experiments experiments) {
        this.experiments = experiments;
        return this;
    }

    public SiteLimits limits() {
        return this.limits;
    }

    public SiteConfigInner withLimits(SiteLimits limits) {
        this.limits = limits;
        return this;
    }

    public Boolean autoHealEnabled() {
        return this.autoHealEnabled;
    }

    public SiteConfigInner withAutoHealEnabled(Boolean autoHealEnabled) {
        this.autoHealEnabled = autoHealEnabled;
        return this;
    }

    public AutoHealRules autoHealRules() {
        return this.autoHealRules;
    }

    public SiteConfigInner withAutoHealRules(AutoHealRules autoHealRules) {
        this.autoHealRules = autoHealRules;
        return this;
    }

    public String tracingOptions() {
        return this.tracingOptions;
    }

    public SiteConfigInner withTracingOptions(String tracingOptions) {
        this.tracingOptions = tracingOptions;
        return this;
    }

    public String vnetName() {
        return this.vnetName;
    }

    public SiteConfigInner withVnetName(String vnetName) {
        this.vnetName = vnetName;
        return this;
    }

    public Boolean vnetRouteAllEnabled() {
        return this.vnetRouteAllEnabled;
    }

    public SiteConfigInner withVnetRouteAllEnabled(Boolean vnetRouteAllEnabled) {
        this.vnetRouteAllEnabled = vnetRouteAllEnabled;
        return this;
    }

    public Integer vnetPrivatePortsCount() {
        return this.vnetPrivatePortsCount;
    }

    public SiteConfigInner withVnetPrivatePortsCount(Integer vnetPrivatePortsCount) {
        this.vnetPrivatePortsCount = vnetPrivatePortsCount;
        return this;
    }

    public CorsSettings cors() {
        return this.cors;
    }

    public SiteConfigInner withCors(CorsSettings cors) {
        this.cors = cors;
        return this;
    }

    public PushSettingsInner push() {
        return this.push;
    }

    public SiteConfigInner withPush(PushSettingsInner push) {
        this.push = push;
        return this;
    }

    public ApiDefinitionInfo apiDefinition() {
        return this.apiDefinition;
    }

    public SiteConfigInner withApiDefinition(ApiDefinitionInfo apiDefinition) {
        this.apiDefinition = apiDefinition;
        return this;
    }

    public ApiManagementConfig apiManagementConfig() {
        return this.apiManagementConfig;
    }

    public SiteConfigInner withApiManagementConfig(ApiManagementConfig apiManagementConfig) {
        this.apiManagementConfig = apiManagementConfig;
        return this;
    }

    public String autoSwapSlotName() {
        return this.autoSwapSlotName;
    }

    public SiteConfigInner withAutoSwapSlotName(String autoSwapSlotName) {
        this.autoSwapSlotName = autoSwapSlotName;
        return this;
    }

    public Boolean localMySqlEnabled() {
        return this.localMySqlEnabled;
    }

    public SiteConfigInner withLocalMySqlEnabled(Boolean localMySqlEnabled) {
        this.localMySqlEnabled = localMySqlEnabled;
        return this;
    }

    public Integer managedServiceIdentityId() {
        return this.managedServiceIdentityId;
    }

    public SiteConfigInner withManagedServiceIdentityId(Integer managedServiceIdentityId) {
        this.managedServiceIdentityId = managedServiceIdentityId;
        return this;
    }

    public Integer xManagedServiceIdentityId() {
        return this.xManagedServiceIdentityId;
    }

    public SiteConfigInner withXManagedServiceIdentityId(Integer xManagedServiceIdentityId) {
        this.xManagedServiceIdentityId = xManagedServiceIdentityId;
        return this;
    }

    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    public SiteConfigInner withKeyVaultReferenceIdentity(String keyVaultReferenceIdentity) {
        this.keyVaultReferenceIdentity = keyVaultReferenceIdentity;
        return this;
    }

    public List<IpSecurityRestriction> ipSecurityRestrictions() {
        return this.ipSecurityRestrictions;
    }

    public SiteConfigInner withIpSecurityRestrictions(List<IpSecurityRestriction> ipSecurityRestrictions) {
        this.ipSecurityRestrictions = ipSecurityRestrictions;
        return this;
    }

    public DefaultAction ipSecurityRestrictionsDefaultAction() {
        return this.ipSecurityRestrictionsDefaultAction;
    }

    public SiteConfigInner withIpSecurityRestrictionsDefaultAction(DefaultAction ipSecurityRestrictionsDefaultAction) {
        this.ipSecurityRestrictionsDefaultAction = ipSecurityRestrictionsDefaultAction;
        return this;
    }

    public List<IpSecurityRestriction> scmIpSecurityRestrictions() {
        return this.scmIpSecurityRestrictions;
    }

    public SiteConfigInner withScmIpSecurityRestrictions(List<IpSecurityRestriction> scmIpSecurityRestrictions) {
        this.scmIpSecurityRestrictions = scmIpSecurityRestrictions;
        return this;
    }

    public DefaultAction scmIpSecurityRestrictionsDefaultAction() {
        return this.scmIpSecurityRestrictionsDefaultAction;
    }

    public SiteConfigInner withScmIpSecurityRestrictionsDefaultAction(DefaultAction scmIpSecurityRestrictionsDefaultAction) {
        this.scmIpSecurityRestrictionsDefaultAction = scmIpSecurityRestrictionsDefaultAction;
        return this;
    }

    public Boolean scmIpSecurityRestrictionsUseMain() {
        return this.scmIpSecurityRestrictionsUseMain;
    }

    public SiteConfigInner withScmIpSecurityRestrictionsUseMain(Boolean scmIpSecurityRestrictionsUseMain) {
        this.scmIpSecurityRestrictionsUseMain = scmIpSecurityRestrictionsUseMain;
        return this;
    }

    public Boolean http20Enabled() {
        return this.http20Enabled;
    }

    public SiteConfigInner withHttp20Enabled(Boolean http20Enabled) {
        this.http20Enabled = http20Enabled;
        return this;
    }

    public SupportedTlsVersions minTlsVersion() {
        return this.minTlsVersion;
    }

    public SiteConfigInner withMinTlsVersion(SupportedTlsVersions minTlsVersion) {
        this.minTlsVersion = minTlsVersion;
        return this;
    }

    public TlsCipherSuites minTlsCipherSuite() {
        return this.minTlsCipherSuite;
    }

    public SiteConfigInner withMinTlsCipherSuite(TlsCipherSuites minTlsCipherSuite) {
        this.minTlsCipherSuite = minTlsCipherSuite;
        return this;
    }

    public SupportedTlsVersions scmMinTlsVersion() {
        return this.scmMinTlsVersion;
    }

    public SiteConfigInner withScmMinTlsVersion(SupportedTlsVersions scmMinTlsVersion) {
        this.scmMinTlsVersion = scmMinTlsVersion;
        return this;
    }

    public FtpsState ftpsState() {
        return this.ftpsState;
    }

    public SiteConfigInner withFtpsState(FtpsState ftpsState) {
        this.ftpsState = ftpsState;
        return this;
    }

    public Integer preWarmedInstanceCount() {
        return this.preWarmedInstanceCount;
    }

    public SiteConfigInner withPreWarmedInstanceCount(Integer preWarmedInstanceCount) {
        this.preWarmedInstanceCount = preWarmedInstanceCount;
        return this;
    }

    public Integer functionAppScaleLimit() {
        return this.functionAppScaleLimit;
    }

    public SiteConfigInner withFunctionAppScaleLimit(Integer functionAppScaleLimit) {
        this.functionAppScaleLimit = functionAppScaleLimit;
        return this;
    }

    public Integer elasticWebAppScaleLimit() {
        return this.elasticWebAppScaleLimit;
    }

    public SiteConfigInner withElasticWebAppScaleLimit(Integer elasticWebAppScaleLimit) {
        this.elasticWebAppScaleLimit = elasticWebAppScaleLimit;
        return this;
    }

    public String healthCheckPath() {
        return this.healthCheckPath;
    }

    public SiteConfigInner withHealthCheckPath(String healthCheckPath) {
        this.healthCheckPath = healthCheckPath;
        return this;
    }

    public Boolean functionsRuntimeScaleMonitoringEnabled() {
        return this.functionsRuntimeScaleMonitoringEnabled;
    }

    public SiteConfigInner withFunctionsRuntimeScaleMonitoringEnabled(Boolean functionsRuntimeScaleMonitoringEnabled) {
        this.functionsRuntimeScaleMonitoringEnabled = functionsRuntimeScaleMonitoringEnabled;
        return this;
    }

    public String websiteTimeZone() {
        return this.websiteTimeZone;
    }

    public SiteConfigInner withWebsiteTimeZone(String websiteTimeZone) {
        this.websiteTimeZone = websiteTimeZone;
        return this;
    }

    public Integer minimumElasticInstanceCount() {
        return this.minimumElasticInstanceCount;
    }

    public SiteConfigInner withMinimumElasticInstanceCount(Integer minimumElasticInstanceCount) {
        this.minimumElasticInstanceCount = minimumElasticInstanceCount;
        return this;
    }

    public Map<String, AzureStorageInfoValue> azureStorageAccounts() {
        return this.azureStorageAccounts;
    }

    public SiteConfigInner withAzureStorageAccounts(Map<String, AzureStorageInfoValue> azureStorageAccounts) {
        this.azureStorageAccounts = azureStorageAccounts;
        return this;
    }

    public String publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public SiteConfigInner withPublicNetworkAccess(String publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public void validate() {
        if (this.appSettings() != null) {
            this.appSettings().forEach(e -> e.validate());
        }
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
        if (this.connectionStrings() != null) {
            this.connectionStrings().forEach(e -> e.validate());
        }
        if (this.machineKey() != null) {
            this.machineKey().validate();
        }
        if (this.handlerMappings() != null) {
            this.handlerMappings().forEach(e -> e.validate());
        }
        if (this.virtualApplications() != null) {
            this.virtualApplications().forEach(e -> e.validate());
        }
        if (this.experiments() != null) {
            this.experiments().validate();
        }
        if (this.limits() != null) {
            this.limits().validate();
        }
        if (this.autoHealRules() != null) {
            this.autoHealRules().validate();
        }
        if (this.cors() != null) {
            this.cors().validate();
        }
        if (this.push() != null) {
            this.push().validate();
        }
        if (this.apiDefinition() != null) {
            this.apiDefinition().validate();
        }
        if (this.apiManagementConfig() != null) {
            this.apiManagementConfig().validate();
        }
        if (this.ipSecurityRestrictions() != null) {
            this.ipSecurityRestrictions().forEach(e -> e.validate());
        }
        if (this.scmIpSecurityRestrictions() != null) {
            this.scmIpSecurityRestrictions().forEach(e -> e.validate());
        }
        if (this.azureStorageAccounts() != null) {
            this.azureStorageAccounts().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("numberOfWorkers", (Number)this.numberOfWorkers);
        jsonWriter.writeArrayField("defaultDocuments", this.defaultDocuments, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("netFrameworkVersion", this.netFrameworkVersion);
        jsonWriter.writeStringField("phpVersion", this.phpVersion);
        jsonWriter.writeStringField("pythonVersion", this.pythonVersion);
        jsonWriter.writeStringField("nodeVersion", this.nodeVersion);
        jsonWriter.writeStringField("powerShellVersion", this.powerShellVersion);
        jsonWriter.writeStringField("linuxFxVersion", this.linuxFxVersion);
        jsonWriter.writeStringField("windowsFxVersion", this.windowsFxVersion);
        jsonWriter.writeBooleanField("requestTracingEnabled", this.requestTracingEnabled);
        jsonWriter.writeStringField("requestTracingExpirationTime", this.requestTracingExpirationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.requestTracingExpirationTime));
        jsonWriter.writeBooleanField("remoteDebuggingEnabled", this.remoteDebuggingEnabled);
        jsonWriter.writeStringField("remoteDebuggingVersion", this.remoteDebuggingVersion);
        jsonWriter.writeBooleanField("httpLoggingEnabled", this.httpLoggingEnabled);
        jsonWriter.writeBooleanField("acrUseManagedIdentityCreds", this.acrUseManagedIdentityCreds);
        jsonWriter.writeStringField("acrUserManagedIdentityID", this.acrUserManagedIdentityId);
        jsonWriter.writeNumberField("logsDirectorySizeLimit", (Number)this.logsDirectorySizeLimit);
        jsonWriter.writeBooleanField("detailedErrorLoggingEnabled", this.detailedErrorLoggingEnabled);
        jsonWriter.writeStringField("publishingUsername", this.publishingUsername);
        jsonWriter.writeArrayField("appSettings", this.appSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("connectionStrings", this.connectionStrings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("handlerMappings", this.handlerMappings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("documentRoot", this.documentRoot);
        jsonWriter.writeStringField("scmType", this.scmType == null ? null : this.scmType.toString());
        jsonWriter.writeBooleanField("use32BitWorkerProcess", this.use32BitWorkerProcess);
        jsonWriter.writeBooleanField("webSocketsEnabled", this.webSocketsEnabled);
        jsonWriter.writeBooleanField("alwaysOn", this.alwaysOn);
        jsonWriter.writeStringField("javaVersion", this.javaVersion);
        jsonWriter.writeStringField("javaContainer", this.javaContainer);
        jsonWriter.writeStringField("javaContainerVersion", this.javaContainerVersion);
        jsonWriter.writeStringField("appCommandLine", this.appCommandLine);
        jsonWriter.writeStringField("managedPipelineMode", this.managedPipelineMode == null ? null : this.managedPipelineMode.toString());
        jsonWriter.writeArrayField("virtualApplications", this.virtualApplications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("loadBalancing", this.loadBalancing == null ? null : this.loadBalancing.toString());
        jsonWriter.writeJsonField("experiments", (JsonSerializable)this.experiments);
        jsonWriter.writeJsonField("limits", (JsonSerializable)this.limits);
        jsonWriter.writeBooleanField("autoHealEnabled", this.autoHealEnabled);
        jsonWriter.writeJsonField("autoHealRules", (JsonSerializable)this.autoHealRules);
        jsonWriter.writeStringField("tracingOptions", this.tracingOptions);
        jsonWriter.writeStringField("vnetName", this.vnetName);
        jsonWriter.writeBooleanField("vnetRouteAllEnabled", this.vnetRouteAllEnabled);
        jsonWriter.writeNumberField("vnetPrivatePortsCount", (Number)this.vnetPrivatePortsCount);
        jsonWriter.writeJsonField("cors", (JsonSerializable)this.cors);
        jsonWriter.writeJsonField("push", (JsonSerializable)this.push);
        jsonWriter.writeJsonField("apiDefinition", (JsonSerializable)this.apiDefinition);
        jsonWriter.writeJsonField("apiManagementConfig", (JsonSerializable)this.apiManagementConfig);
        jsonWriter.writeStringField("autoSwapSlotName", this.autoSwapSlotName);
        jsonWriter.writeBooleanField("localMySqlEnabled", this.localMySqlEnabled);
        jsonWriter.writeNumberField("managedServiceIdentityId", (Number)this.managedServiceIdentityId);
        jsonWriter.writeNumberField("xManagedServiceIdentityId", (Number)this.xManagedServiceIdentityId);
        jsonWriter.writeStringField("keyVaultReferenceIdentity", this.keyVaultReferenceIdentity);
        jsonWriter.writeArrayField("ipSecurityRestrictions", this.ipSecurityRestrictions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("ipSecurityRestrictionsDefaultAction", this.ipSecurityRestrictionsDefaultAction == null ? null : this.ipSecurityRestrictionsDefaultAction.toString());
        jsonWriter.writeArrayField("scmIpSecurityRestrictions", this.scmIpSecurityRestrictions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("scmIpSecurityRestrictionsDefaultAction", this.scmIpSecurityRestrictionsDefaultAction == null ? null : this.scmIpSecurityRestrictionsDefaultAction.toString());
        jsonWriter.writeBooleanField("scmIpSecurityRestrictionsUseMain", this.scmIpSecurityRestrictionsUseMain);
        jsonWriter.writeBooleanField("http20Enabled", this.http20Enabled);
        jsonWriter.writeStringField("minTlsVersion", this.minTlsVersion == null ? null : this.minTlsVersion.toString());
        jsonWriter.writeStringField("minTlsCipherSuite", this.minTlsCipherSuite == null ? null : this.minTlsCipherSuite.toString());
        jsonWriter.writeStringField("scmMinTlsVersion", this.scmMinTlsVersion == null ? null : this.scmMinTlsVersion.toString());
        jsonWriter.writeStringField("ftpsState", this.ftpsState == null ? null : this.ftpsState.toString());
        jsonWriter.writeNumberField("preWarmedInstanceCount", (Number)this.preWarmedInstanceCount);
        jsonWriter.writeNumberField("functionAppScaleLimit", (Number)this.functionAppScaleLimit);
        jsonWriter.writeNumberField("elasticWebAppScaleLimit", (Number)this.elasticWebAppScaleLimit);
        jsonWriter.writeStringField("healthCheckPath", this.healthCheckPath);
        jsonWriter.writeBooleanField("functionsRuntimeScaleMonitoringEnabled", this.functionsRuntimeScaleMonitoringEnabled);
        jsonWriter.writeStringField("websiteTimeZone", this.websiteTimeZone);
        jsonWriter.writeNumberField("minimumElasticInstanceCount", (Number)this.minimumElasticInstanceCount);
        jsonWriter.writeMapField("azureStorageAccounts", this.azureStorageAccounts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess);
        return jsonWriter.writeEndObject();
    }

    public static SiteConfigInner fromJson(JsonReader jsonReader) throws IOException {
        return (SiteConfigInner)jsonReader.readObject(reader -> {
            SiteConfigInner deserializedSiteConfigInner = new SiteConfigInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("numberOfWorkers".equals(fieldName)) {
                    deserializedSiteConfigInner.numberOfWorkers = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("defaultDocuments".equals(fieldName)) {
                    List defaultDocuments;
                    deserializedSiteConfigInner.defaultDocuments = defaultDocuments = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("netFrameworkVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.netFrameworkVersion = reader.getString();
                    continue;
                }
                if ("phpVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.phpVersion = reader.getString();
                    continue;
                }
                if ("pythonVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.pythonVersion = reader.getString();
                    continue;
                }
                if ("nodeVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.nodeVersion = reader.getString();
                    continue;
                }
                if ("powerShellVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.powerShellVersion = reader.getString();
                    continue;
                }
                if ("linuxFxVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.linuxFxVersion = reader.getString();
                    continue;
                }
                if ("windowsFxVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.windowsFxVersion = reader.getString();
                    continue;
                }
                if ("requestTracingEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.requestTracingEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("requestTracingExpirationTime".equals(fieldName)) {
                    deserializedSiteConfigInner.requestTracingExpirationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("remoteDebuggingEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.remoteDebuggingEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("remoteDebuggingVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.remoteDebuggingVersion = reader.getString();
                    continue;
                }
                if ("httpLoggingEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.httpLoggingEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("acrUseManagedIdentityCreds".equals(fieldName)) {
                    deserializedSiteConfigInner.acrUseManagedIdentityCreds = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("acrUserManagedIdentityID".equals(fieldName)) {
                    deserializedSiteConfigInner.acrUserManagedIdentityId = reader.getString();
                    continue;
                }
                if ("logsDirectorySizeLimit".equals(fieldName)) {
                    deserializedSiteConfigInner.logsDirectorySizeLimit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("detailedErrorLoggingEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.detailedErrorLoggingEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publishingUsername".equals(fieldName)) {
                    deserializedSiteConfigInner.publishingUsername = reader.getString();
                    continue;
                }
                if ("appSettings".equals(fieldName)) {
                    List appSettings;
                    deserializedSiteConfigInner.appSettings = appSettings = reader.readArray(reader1 -> NameValuePair.fromJson(reader1));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedSiteConfigInner.metadata = metadata = reader.readArray(reader1 -> NameValuePair.fromJson(reader1));
                    continue;
                }
                if ("connectionStrings".equals(fieldName)) {
                    List connectionStrings;
                    deserializedSiteConfigInner.connectionStrings = connectionStrings = reader.readArray(reader1 -> ConnStringInfo.fromJson(reader1));
                    continue;
                }
                if ("machineKey".equals(fieldName)) {
                    deserializedSiteConfigInner.machineKey = SiteMachineKey.fromJson(reader);
                    continue;
                }
                if ("handlerMappings".equals(fieldName)) {
                    List handlerMappings;
                    deserializedSiteConfigInner.handlerMappings = handlerMappings = reader.readArray(reader1 -> HandlerMapping.fromJson(reader1));
                    continue;
                }
                if ("documentRoot".equals(fieldName)) {
                    deserializedSiteConfigInner.documentRoot = reader.getString();
                    continue;
                }
                if ("scmType".equals(fieldName)) {
                    deserializedSiteConfigInner.scmType = ScmType.fromString(reader.getString());
                    continue;
                }
                if ("use32BitWorkerProcess".equals(fieldName)) {
                    deserializedSiteConfigInner.use32BitWorkerProcess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("webSocketsEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.webSocketsEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("alwaysOn".equals(fieldName)) {
                    deserializedSiteConfigInner.alwaysOn = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("javaVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.javaVersion = reader.getString();
                    continue;
                }
                if ("javaContainer".equals(fieldName)) {
                    deserializedSiteConfigInner.javaContainer = reader.getString();
                    continue;
                }
                if ("javaContainerVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.javaContainerVersion = reader.getString();
                    continue;
                }
                if ("appCommandLine".equals(fieldName)) {
                    deserializedSiteConfigInner.appCommandLine = reader.getString();
                    continue;
                }
                if ("managedPipelineMode".equals(fieldName)) {
                    deserializedSiteConfigInner.managedPipelineMode = ManagedPipelineMode.fromString(reader.getString());
                    continue;
                }
                if ("virtualApplications".equals(fieldName)) {
                    List virtualApplications;
                    deserializedSiteConfigInner.virtualApplications = virtualApplications = reader.readArray(reader1 -> VirtualApplication.fromJson(reader1));
                    continue;
                }
                if ("loadBalancing".equals(fieldName)) {
                    deserializedSiteConfigInner.loadBalancing = SiteLoadBalancing.fromString(reader.getString());
                    continue;
                }
                if ("experiments".equals(fieldName)) {
                    deserializedSiteConfigInner.experiments = Experiments.fromJson(reader);
                    continue;
                }
                if ("limits".equals(fieldName)) {
                    deserializedSiteConfigInner.limits = SiteLimits.fromJson(reader);
                    continue;
                }
                if ("autoHealEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.autoHealEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoHealRules".equals(fieldName)) {
                    deserializedSiteConfigInner.autoHealRules = AutoHealRules.fromJson(reader);
                    continue;
                }
                if ("tracingOptions".equals(fieldName)) {
                    deserializedSiteConfigInner.tracingOptions = reader.getString();
                    continue;
                }
                if ("vnetName".equals(fieldName)) {
                    deserializedSiteConfigInner.vnetName = reader.getString();
                    continue;
                }
                if ("vnetRouteAllEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.vnetRouteAllEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("vnetPrivatePortsCount".equals(fieldName)) {
                    deserializedSiteConfigInner.vnetPrivatePortsCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cors".equals(fieldName)) {
                    deserializedSiteConfigInner.cors = CorsSettings.fromJson(reader);
                    continue;
                }
                if ("push".equals(fieldName)) {
                    deserializedSiteConfigInner.push = PushSettingsInner.fromJson(reader);
                    continue;
                }
                if ("apiDefinition".equals(fieldName)) {
                    deserializedSiteConfigInner.apiDefinition = ApiDefinitionInfo.fromJson(reader);
                    continue;
                }
                if ("apiManagementConfig".equals(fieldName)) {
                    deserializedSiteConfigInner.apiManagementConfig = ApiManagementConfig.fromJson(reader);
                    continue;
                }
                if ("autoSwapSlotName".equals(fieldName)) {
                    deserializedSiteConfigInner.autoSwapSlotName = reader.getString();
                    continue;
                }
                if ("localMySqlEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.localMySqlEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("managedServiceIdentityId".equals(fieldName)) {
                    deserializedSiteConfigInner.managedServiceIdentityId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("xManagedServiceIdentityId".equals(fieldName)) {
                    deserializedSiteConfigInner.xManagedServiceIdentityId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("keyVaultReferenceIdentity".equals(fieldName)) {
                    deserializedSiteConfigInner.keyVaultReferenceIdentity = reader.getString();
                    continue;
                }
                if ("ipSecurityRestrictions".equals(fieldName)) {
                    List ipSecurityRestrictions;
                    deserializedSiteConfigInner.ipSecurityRestrictions = ipSecurityRestrictions = reader.readArray(reader1 -> IpSecurityRestriction.fromJson(reader1));
                    continue;
                }
                if ("ipSecurityRestrictionsDefaultAction".equals(fieldName)) {
                    deserializedSiteConfigInner.ipSecurityRestrictionsDefaultAction = DefaultAction.fromString(reader.getString());
                    continue;
                }
                if ("scmIpSecurityRestrictions".equals(fieldName)) {
                    List scmIpSecurityRestrictions;
                    deserializedSiteConfigInner.scmIpSecurityRestrictions = scmIpSecurityRestrictions = reader.readArray(reader1 -> IpSecurityRestriction.fromJson(reader1));
                    continue;
                }
                if ("scmIpSecurityRestrictionsDefaultAction".equals(fieldName)) {
                    deserializedSiteConfigInner.scmIpSecurityRestrictionsDefaultAction = DefaultAction.fromString(reader.getString());
                    continue;
                }
                if ("scmIpSecurityRestrictionsUseMain".equals(fieldName)) {
                    deserializedSiteConfigInner.scmIpSecurityRestrictionsUseMain = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("http20Enabled".equals(fieldName)) {
                    deserializedSiteConfigInner.http20Enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("minTlsVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.minTlsVersion = SupportedTlsVersions.fromString(reader.getString());
                    continue;
                }
                if ("minTlsCipherSuite".equals(fieldName)) {
                    deserializedSiteConfigInner.minTlsCipherSuite = TlsCipherSuites.fromString(reader.getString());
                    continue;
                }
                if ("scmMinTlsVersion".equals(fieldName)) {
                    deserializedSiteConfigInner.scmMinTlsVersion = SupportedTlsVersions.fromString(reader.getString());
                    continue;
                }
                if ("ftpsState".equals(fieldName)) {
                    deserializedSiteConfigInner.ftpsState = FtpsState.fromString(reader.getString());
                    continue;
                }
                if ("preWarmedInstanceCount".equals(fieldName)) {
                    deserializedSiteConfigInner.preWarmedInstanceCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("functionAppScaleLimit".equals(fieldName)) {
                    deserializedSiteConfigInner.functionAppScaleLimit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("elasticWebAppScaleLimit".equals(fieldName)) {
                    deserializedSiteConfigInner.elasticWebAppScaleLimit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("healthCheckPath".equals(fieldName)) {
                    deserializedSiteConfigInner.healthCheckPath = reader.getString();
                    continue;
                }
                if ("functionsRuntimeScaleMonitoringEnabled".equals(fieldName)) {
                    deserializedSiteConfigInner.functionsRuntimeScaleMonitoringEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("websiteTimeZone".equals(fieldName)) {
                    deserializedSiteConfigInner.websiteTimeZone = reader.getString();
                    continue;
                }
                if ("minimumElasticInstanceCount".equals(fieldName)) {
                    deserializedSiteConfigInner.minimumElasticInstanceCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("azureStorageAccounts".equals(fieldName)) {
                    Map azureStorageAccounts;
                    deserializedSiteConfigInner.azureStorageAccounts = azureStorageAccounts = reader.readMap(reader1 -> AzureStorageInfoValue.fromJson(reader1));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedSiteConfigInner.publicNetworkAccess = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteConfigInner;
        });
    }
}

