/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentStatus;
import com.azure.resourcemanager.appservice.models.LoadBalancingMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.VirtualNetworkProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class AppServiceEnvironmentResourceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AppServiceEnvironmentResourceInner.class);
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.status", access=JsonProperty.Access.WRITE_ONLY)
    private HostingEnvironmentStatus status;
    @JsonProperty(value="properties.virtualNetwork")
    private VirtualNetworkProfile virtualNetwork;
    @JsonProperty(value="properties.internalLoadBalancingMode")
    private LoadBalancingMode internalLoadBalancingMode;
    @JsonProperty(value="properties.multiSize")
    private String multiSize;
    @JsonProperty(value="properties.multiRoleCount", access=JsonProperty.Access.WRITE_ONLY)
    private Integer multiRoleCount;
    @JsonProperty(value="properties.ipsslAddressCount")
    private Integer ipsslAddressCount;
    @JsonProperty(value="properties.dnsSuffix")
    private String dnsSuffix;
    @JsonProperty(value="properties.maximumNumberOfMachines", access=JsonProperty.Access.WRITE_ONLY)
    private Integer maximumNumberOfMachines;
    @JsonProperty(value="properties.frontEndScaleFactor")
    private Integer frontEndScaleFactor;
    @JsonProperty(value="properties.suspended", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean suspended;
    @JsonProperty(value="properties.clusterSettings")
    private List<NameValuePair> clusterSettings;
    @JsonProperty(value="properties.userWhitelistedIpRanges")
    private List<String> userWhitelistedIpRanges;
    @JsonProperty(value="properties.hasLinuxWorkers", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean hasLinuxWorkers;
    @JsonProperty(value="properties.dedicatedHostCount", access=JsonProperty.Access.WRITE_ONLY)
    private Integer dedicatedHostCount;
    @JsonProperty(value="kind")
    private String kind;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public HostingEnvironmentStatus status() {
        return this.status;
    }

    public VirtualNetworkProfile virtualNetwork() {
        return this.virtualNetwork;
    }

    public AppServiceEnvironmentResourceInner withVirtualNetwork(VirtualNetworkProfile virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public LoadBalancingMode internalLoadBalancingMode() {
        return this.internalLoadBalancingMode;
    }

    public AppServiceEnvironmentResourceInner withInternalLoadBalancingMode(LoadBalancingMode internalLoadBalancingMode) {
        this.internalLoadBalancingMode = internalLoadBalancingMode;
        return this;
    }

    public String multiSize() {
        return this.multiSize;
    }

    public AppServiceEnvironmentResourceInner withMultiSize(String multiSize) {
        this.multiSize = multiSize;
        return this;
    }

    public Integer multiRoleCount() {
        return this.multiRoleCount;
    }

    public Integer ipsslAddressCount() {
        return this.ipsslAddressCount;
    }

    public AppServiceEnvironmentResourceInner withIpsslAddressCount(Integer ipsslAddressCount) {
        this.ipsslAddressCount = ipsslAddressCount;
        return this;
    }

    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    public AppServiceEnvironmentResourceInner withDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
        return this;
    }

    public Integer maximumNumberOfMachines() {
        return this.maximumNumberOfMachines;
    }

    public Integer frontEndScaleFactor() {
        return this.frontEndScaleFactor;
    }

    public AppServiceEnvironmentResourceInner withFrontEndScaleFactor(Integer frontEndScaleFactor) {
        this.frontEndScaleFactor = frontEndScaleFactor;
        return this;
    }

    public Boolean suspended() {
        return this.suspended;
    }

    public List<NameValuePair> clusterSettings() {
        return this.clusterSettings;
    }

    public AppServiceEnvironmentResourceInner withClusterSettings(List<NameValuePair> clusterSettings) {
        this.clusterSettings = clusterSettings;
        return this;
    }

    public List<String> userWhitelistedIpRanges() {
        return this.userWhitelistedIpRanges;
    }

    public AppServiceEnvironmentResourceInner withUserWhitelistedIpRanges(List<String> userWhitelistedIpRanges) {
        this.userWhitelistedIpRanges = userWhitelistedIpRanges;
        return this;
    }

    public Boolean hasLinuxWorkers() {
        return this.hasLinuxWorkers;
    }

    public Integer dedicatedHostCount() {
        return this.dedicatedHostCount;
    }

    public String kind() {
        return this.kind;
    }

    public AppServiceEnvironmentResourceInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public AppServiceEnvironmentResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AppServiceEnvironmentResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.virtualNetwork() != null) {
            this.virtualNetwork().validate();
        }
        if (this.clusterSettings() != null) {
            this.clusterSettings().forEach(e -> e.validate());
        }
    }
}

