/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.BackupItemStatus;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

@JsonFlatten
public class BackupItemInner
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BackupItemInner.class);
    @JsonProperty(value="properties.id", access=JsonProperty.Access.WRITE_ONLY)
    private Integer backupId;
    @JsonProperty(value="properties.storageAccountUrl", access=JsonProperty.Access.WRITE_ONLY)
    private String storageAccountUrl;
    @JsonProperty(value="properties.blobName", access=JsonProperty.Access.WRITE_ONLY)
    private String blobName;
    @JsonProperty(value="properties.name", access=JsonProperty.Access.WRITE_ONLY)
    private String namePropertiesName;
    @JsonProperty(value="properties.status", access=JsonProperty.Access.WRITE_ONLY)
    private BackupItemStatus status;
    @JsonProperty(value="properties.sizeInBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long sizeInBytes;
    @JsonProperty(value="properties.created", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime created;
    @JsonProperty(value="properties.log", access=JsonProperty.Access.WRITE_ONLY)
    private String log;
    @JsonProperty(value="properties.databases", access=JsonProperty.Access.WRITE_ONLY)
    private List<DatabaseBackupSetting> databases;
    @JsonProperty(value="properties.scheduled", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean scheduled;
    @JsonProperty(value="properties.lastRestoreTimeStamp", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastRestoreTimestamp;
    @JsonProperty(value="properties.finishedTimeStamp", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime finishedTimestamp;
    @JsonProperty(value="properties.correlationId", access=JsonProperty.Access.WRITE_ONLY)
    private String correlationId;
    @JsonProperty(value="properties.websiteSizeInBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long websiteSizeInBytes;

    public Integer backupId() {
        return this.backupId;
    }

    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    public String blobName() {
        return this.blobName;
    }

    public String namePropertiesName() {
        return this.namePropertiesName;
    }

    public BackupItemStatus status() {
        return this.status;
    }

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public OffsetDateTime created() {
        return this.created;
    }

    public String log() {
        return this.log;
    }

    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    public Boolean scheduled() {
        return this.scheduled;
    }

    public OffsetDateTime lastRestoreTimestamp() {
        return this.lastRestoreTimestamp;
    }

    public OffsetDateTime finishedTimestamp() {
        return this.finishedTimestamp;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public Long websiteSizeInBytes() {
        return this.websiteSizeInBytes;
    }

    @Override
    public BackupItemInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
    }
}

