/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.BackupSchedule;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class BackupRequestInner
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BackupRequestInner.class);
    @JsonProperty(value="properties.backupName")
    private String backupName;
    @JsonProperty(value="properties.enabled")
    private Boolean enabled;
    @JsonProperty(value="properties.storageAccountUrl")
    private String storageAccountUrl;
    @JsonProperty(value="properties.backupSchedule")
    private BackupSchedule backupSchedule;
    @JsonProperty(value="properties.databases")
    private List<DatabaseBackupSetting> databases;

    public String backupName() {
        return this.backupName;
    }

    public BackupRequestInner withBackupName(String backupName) {
        this.backupName = backupName;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public BackupRequestInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    public BackupRequestInner withStorageAccountUrl(String storageAccountUrl) {
        this.storageAccountUrl = storageAccountUrl;
        return this;
    }

    public BackupSchedule backupSchedule() {
        return this.backupSchedule;
    }

    public BackupRequestInner withBackupSchedule(BackupSchedule backupSchedule) {
        this.backupSchedule = backupSchedule;
        return this;
    }

    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    public BackupRequestInner withDatabases(List<DatabaseBackupSetting> databases) {
        this.databases = databases;
        return this;
    }

    @Override
    public BackupRequestInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.backupSchedule() != null) {
            this.backupSchedule().validate();
        }
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
    }
}

