/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.Contact;
import com.azure.resourcemanager.appservice.models.DnsType;
import com.azure.resourcemanager.appservice.models.DomainPropertiesDomainNotRenewableReasonsItem;
import com.azure.resourcemanager.appservice.models.DomainPurchaseConsent;
import com.azure.resourcemanager.appservice.models.DomainStatus;
import com.azure.resourcemanager.appservice.models.Hostname;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class DomainInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DomainInner.class);
    @JsonProperty(value="properties.contactAdmin")
    private Contact contactAdmin;
    @JsonProperty(value="properties.contactBilling")
    private Contact contactBilling;
    @JsonProperty(value="properties.contactRegistrant")
    private Contact contactRegistrant;
    @JsonProperty(value="properties.contactTech")
    private Contact contactTech;
    @JsonProperty(value="properties.registrationStatus", access=JsonProperty.Access.WRITE_ONLY)
    private DomainStatus registrationStatus;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.nameServers", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> nameServers;
    @JsonProperty(value="properties.privacy")
    private Boolean privacy;
    @JsonProperty(value="properties.createdTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdTime;
    @JsonProperty(value="properties.expirationTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime expirationTime;
    @JsonProperty(value="properties.lastRenewedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastRenewedTime;
    @JsonProperty(value="properties.autoRenew")
    private Boolean autoRenew;
    @JsonProperty(value="properties.readyForDnsRecordManagement", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean readyForDnsRecordManagement;
    @JsonProperty(value="properties.managedHostNames", access=JsonProperty.Access.WRITE_ONLY)
    private List<Hostname> managedHostNames;
    @JsonProperty(value="properties.consent")
    private DomainPurchaseConsent consent;
    @JsonProperty(value="properties.domainNotRenewableReasons", access=JsonProperty.Access.WRITE_ONLY)
    private List<DomainPropertiesDomainNotRenewableReasonsItem> domainNotRenewableReasons;
    @JsonProperty(value="properties.dnsType")
    private DnsType dnsType;
    @JsonProperty(value="properties.dnsZoneId")
    private String dnsZoneId;
    @JsonProperty(value="properties.targetDnsType")
    private DnsType targetDnsType;
    @JsonProperty(value="properties.authCode")
    private String authCode;
    @JsonProperty(value="kind")
    private String kind;

    public Contact contactAdmin() {
        return this.contactAdmin;
    }

    public DomainInner withContactAdmin(Contact contactAdmin) {
        this.contactAdmin = contactAdmin;
        return this;
    }

    public Contact contactBilling() {
        return this.contactBilling;
    }

    public DomainInner withContactBilling(Contact contactBilling) {
        this.contactBilling = contactBilling;
        return this;
    }

    public Contact contactRegistrant() {
        return this.contactRegistrant;
    }

    public DomainInner withContactRegistrant(Contact contactRegistrant) {
        this.contactRegistrant = contactRegistrant;
        return this;
    }

    public Contact contactTech() {
        return this.contactTech;
    }

    public DomainInner withContactTech(Contact contactTech) {
        this.contactTech = contactTech;
        return this;
    }

    public DomainStatus registrationStatus() {
        return this.registrationStatus;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<String> nameServers() {
        return this.nameServers;
    }

    public Boolean privacy() {
        return this.privacy;
    }

    public DomainInner withPrivacy(Boolean privacy) {
        this.privacy = privacy;
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime expirationTime() {
        return this.expirationTime;
    }

    public OffsetDateTime lastRenewedTime() {
        return this.lastRenewedTime;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public DomainInner withAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    public Boolean readyForDnsRecordManagement() {
        return this.readyForDnsRecordManagement;
    }

    public List<Hostname> managedHostNames() {
        return this.managedHostNames;
    }

    public DomainPurchaseConsent consent() {
        return this.consent;
    }

    public DomainInner withConsent(DomainPurchaseConsent consent) {
        this.consent = consent;
        return this;
    }

    public List<DomainPropertiesDomainNotRenewableReasonsItem> domainNotRenewableReasons() {
        return this.domainNotRenewableReasons;
    }

    public DnsType dnsType() {
        return this.dnsType;
    }

    public DomainInner withDnsType(DnsType dnsType) {
        this.dnsType = dnsType;
        return this;
    }

    public String dnsZoneId() {
        return this.dnsZoneId;
    }

    public DomainInner withDnsZoneId(String dnsZoneId) {
        this.dnsZoneId = dnsZoneId;
        return this;
    }

    public DnsType targetDnsType() {
        return this.targetDnsType;
    }

    public DomainInner withTargetDnsType(DnsType targetDnsType) {
        this.targetDnsType = targetDnsType;
        return this;
    }

    public String authCode() {
        return this.authCode;
    }

    public DomainInner withAuthCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public DomainInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public DomainInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DomainInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.contactAdmin() != null) {
            this.contactAdmin().validate();
        }
        if (this.contactBilling() != null) {
            this.contactBilling().validate();
        }
        if (this.contactRegistrant() != null) {
            this.contactRegistrant().validate();
        }
        if (this.contactTech() != null) {
            this.contactTech().validate();
        }
        if (this.managedHostNames() != null) {
            this.managedHostNames().forEach(e -> e.validate());
        }
        if (this.consent() != null) {
            this.consent().validate();
        }
    }
}

