/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigInner;
import com.azure.resourcemanager.appservice.models.ClientCertMode;
import com.azure.resourcemanager.appservice.models.CloningInfo;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.HostnameSslState;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.RedundancyMode;
import com.azure.resourcemanager.appservice.models.SiteAvailabilityState;
import com.azure.resourcemanager.appservice.models.SlotSwapStatus;
import com.azure.resourcemanager.appservice.models.UsageState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;

@JsonFlatten
public class SitePatchResourceInner
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SitePatchResourceInner.class);
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="properties.state", access=JsonProperty.Access.WRITE_ONLY)
    private String state;
    @JsonProperty(value="properties.hostNames", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> hostNames;
    @JsonProperty(value="properties.repositorySiteName", access=JsonProperty.Access.WRITE_ONLY)
    private String repositorySiteName;
    @JsonProperty(value="properties.usageState", access=JsonProperty.Access.WRITE_ONLY)
    private UsageState usageState;
    @JsonProperty(value="properties.enabled")
    private Boolean enabled;
    @JsonProperty(value="properties.enabledHostNames", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> enabledHostNames;
    @JsonProperty(value="properties.availabilityState", access=JsonProperty.Access.WRITE_ONLY)
    private SiteAvailabilityState availabilityState;
    @JsonProperty(value="properties.hostNameSslStates")
    private List<HostnameSslState> hostnameSslStates;
    @JsonProperty(value="properties.serverFarmId")
    private String serverFarmId;
    @JsonProperty(value="properties.reserved")
    private Boolean reserved;
    @JsonProperty(value="properties.isXenon")
    private Boolean isXenon;
    @JsonProperty(value="properties.hyperV")
    private Boolean hyperV;
    @JsonProperty(value="properties.lastModifiedTimeUtc", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedTimeUtc;
    @JsonProperty(value="properties.siteConfig")
    private SiteConfigInner siteConfig;
    @JsonProperty(value="properties.trafficManagerHostNames", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> trafficManagerHostNames;
    @JsonProperty(value="properties.scmSiteAlsoStopped")
    private Boolean scmSiteAlsoStopped;
    @JsonProperty(value="properties.targetSwapSlot", access=JsonProperty.Access.WRITE_ONLY)
    private String targetSwapSlot;
    @JsonProperty(value="properties.hostingEnvironmentProfile")
    private HostingEnvironmentProfile hostingEnvironmentProfile;
    @JsonProperty(value="properties.clientAffinityEnabled")
    private Boolean clientAffinityEnabled;
    @JsonProperty(value="properties.clientCertEnabled")
    private Boolean clientCertEnabled;
    @JsonProperty(value="properties.clientCertMode")
    private ClientCertMode clientCertMode;
    @JsonProperty(value="properties.clientCertExclusionPaths")
    private String clientCertExclusionPaths;
    @JsonProperty(value="properties.hostNamesDisabled")
    private Boolean hostNamesDisabled;
    @JsonProperty(value="properties.customDomainVerificationId")
    private String customDomainVerificationId;
    @JsonProperty(value="properties.outboundIpAddresses", access=JsonProperty.Access.WRITE_ONLY)
    private String outboundIpAddresses;
    @JsonProperty(value="properties.possibleOutboundIpAddresses", access=JsonProperty.Access.WRITE_ONLY)
    private String possibleOutboundIpAddresses;
    @JsonProperty(value="properties.containerSize")
    private Integer containerSize;
    @JsonProperty(value="properties.dailyMemoryTimeQuota")
    private Integer dailyMemoryTimeQuota;
    @JsonProperty(value="properties.suspendedTill", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime suspendedTill;
    @JsonProperty(value="properties.maxNumberOfWorkers", access=JsonProperty.Access.WRITE_ONLY)
    private Integer maxNumberOfWorkers;
    @JsonProperty(value="properties.cloningInfo")
    private CloningInfo cloningInfo;
    @JsonProperty(value="properties.resourceGroup", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGroup;
    @JsonProperty(value="properties.isDefaultContainer", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isDefaultContainer;
    @JsonProperty(value="properties.defaultHostName", access=JsonProperty.Access.WRITE_ONLY)
    private String defaultHostname;
    @JsonProperty(value="properties.slotSwapStatus", access=JsonProperty.Access.WRITE_ONLY)
    private SlotSwapStatus slotSwapStatus;
    @JsonProperty(value="properties.keyVaultReferenceIdentity")
    private String keyVaultReferenceIdentity;
    @JsonProperty(value="properties.httpsOnly")
    private Boolean httpsOnly;
    @JsonProperty(value="properties.redundancyMode")
    private RedundancyMode redundancyMode;
    @JsonProperty(value="properties.inProgressOperationId", access=JsonProperty.Access.WRITE_ONLY)
    private UUID inProgressOperationId;
    @JsonProperty(value="properties.storageAccountRequired")
    private Boolean storageAccountRequired;

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public SitePatchResourceInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String state() {
        return this.state;
    }

    public List<String> hostNames() {
        return this.hostNames;
    }

    public String repositorySiteName() {
        return this.repositorySiteName;
    }

    public UsageState usageState() {
        return this.usageState;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public SitePatchResourceInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> enabledHostNames() {
        return this.enabledHostNames;
    }

    public SiteAvailabilityState availabilityState() {
        return this.availabilityState;
    }

    public List<HostnameSslState> hostnameSslStates() {
        return this.hostnameSslStates;
    }

    public SitePatchResourceInner withHostnameSslStates(List<HostnameSslState> hostnameSslStates) {
        this.hostnameSslStates = hostnameSslStates;
        return this;
    }

    public String serverFarmId() {
        return this.serverFarmId;
    }

    public SitePatchResourceInner withServerFarmId(String serverFarmId) {
        this.serverFarmId = serverFarmId;
        return this;
    }

    public Boolean reserved() {
        return this.reserved;
    }

    public SitePatchResourceInner withReserved(Boolean reserved) {
        this.reserved = reserved;
        return this;
    }

    public Boolean isXenon() {
        return this.isXenon;
    }

    public SitePatchResourceInner withIsXenon(Boolean isXenon) {
        this.isXenon = isXenon;
        return this;
    }

    public Boolean hyperV() {
        return this.hyperV;
    }

    public SitePatchResourceInner withHyperV(Boolean hyperV) {
        this.hyperV = hyperV;
        return this;
    }

    public OffsetDateTime lastModifiedTimeUtc() {
        return this.lastModifiedTimeUtc;
    }

    public SiteConfigInner siteConfig() {
        return this.siteConfig;
    }

    public SitePatchResourceInner withSiteConfig(SiteConfigInner siteConfig) {
        this.siteConfig = siteConfig;
        return this;
    }

    public List<String> trafficManagerHostNames() {
        return this.trafficManagerHostNames;
    }

    public Boolean scmSiteAlsoStopped() {
        return this.scmSiteAlsoStopped;
    }

    public SitePatchResourceInner withScmSiteAlsoStopped(Boolean scmSiteAlsoStopped) {
        this.scmSiteAlsoStopped = scmSiteAlsoStopped;
        return this;
    }

    public String targetSwapSlot() {
        return this.targetSwapSlot;
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.hostingEnvironmentProfile;
    }

    public SitePatchResourceInner withHostingEnvironmentProfile(HostingEnvironmentProfile hostingEnvironmentProfile) {
        this.hostingEnvironmentProfile = hostingEnvironmentProfile;
        return this;
    }

    public Boolean clientAffinityEnabled() {
        return this.clientAffinityEnabled;
    }

    public SitePatchResourceInner withClientAffinityEnabled(Boolean clientAffinityEnabled) {
        this.clientAffinityEnabled = clientAffinityEnabled;
        return this;
    }

    public Boolean clientCertEnabled() {
        return this.clientCertEnabled;
    }

    public SitePatchResourceInner withClientCertEnabled(Boolean clientCertEnabled) {
        this.clientCertEnabled = clientCertEnabled;
        return this;
    }

    public ClientCertMode clientCertMode() {
        return this.clientCertMode;
    }

    public SitePatchResourceInner withClientCertMode(ClientCertMode clientCertMode) {
        this.clientCertMode = clientCertMode;
        return this;
    }

    public String clientCertExclusionPaths() {
        return this.clientCertExclusionPaths;
    }

    public SitePatchResourceInner withClientCertExclusionPaths(String clientCertExclusionPaths) {
        this.clientCertExclusionPaths = clientCertExclusionPaths;
        return this;
    }

    public Boolean hostNamesDisabled() {
        return this.hostNamesDisabled;
    }

    public SitePatchResourceInner withHostNamesDisabled(Boolean hostNamesDisabled) {
        this.hostNamesDisabled = hostNamesDisabled;
        return this;
    }

    public String customDomainVerificationId() {
        return this.customDomainVerificationId;
    }

    public SitePatchResourceInner withCustomDomainVerificationId(String customDomainVerificationId) {
        this.customDomainVerificationId = customDomainVerificationId;
        return this;
    }

    public String outboundIpAddresses() {
        return this.outboundIpAddresses;
    }

    public String possibleOutboundIpAddresses() {
        return this.possibleOutboundIpAddresses;
    }

    public Integer containerSize() {
        return this.containerSize;
    }

    public SitePatchResourceInner withContainerSize(Integer containerSize) {
        this.containerSize = containerSize;
        return this;
    }

    public Integer dailyMemoryTimeQuota() {
        return this.dailyMemoryTimeQuota;
    }

    public SitePatchResourceInner withDailyMemoryTimeQuota(Integer dailyMemoryTimeQuota) {
        this.dailyMemoryTimeQuota = dailyMemoryTimeQuota;
        return this;
    }

    public OffsetDateTime suspendedTill() {
        return this.suspendedTill;
    }

    public Integer maxNumberOfWorkers() {
        return this.maxNumberOfWorkers;
    }

    public CloningInfo cloningInfo() {
        return this.cloningInfo;
    }

    public SitePatchResourceInner withCloningInfo(CloningInfo cloningInfo) {
        this.cloningInfo = cloningInfo;
        return this;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public Boolean isDefaultContainer() {
        return this.isDefaultContainer;
    }

    public String defaultHostname() {
        return this.defaultHostname;
    }

    public SlotSwapStatus slotSwapStatus() {
        return this.slotSwapStatus;
    }

    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    public SitePatchResourceInner withKeyVaultReferenceIdentity(String keyVaultReferenceIdentity) {
        this.keyVaultReferenceIdentity = keyVaultReferenceIdentity;
        return this;
    }

    public Boolean httpsOnly() {
        return this.httpsOnly;
    }

    public SitePatchResourceInner withHttpsOnly(Boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    public RedundancyMode redundancyMode() {
        return this.redundancyMode;
    }

    public SitePatchResourceInner withRedundancyMode(RedundancyMode redundancyMode) {
        this.redundancyMode = redundancyMode;
        return this;
    }

    public UUID inProgressOperationId() {
        return this.inProgressOperationId;
    }

    public Boolean storageAccountRequired() {
        return this.storageAccountRequired;
    }

    public SitePatchResourceInner withStorageAccountRequired(Boolean storageAccountRequired) {
        this.storageAccountRequired = storageAccountRequired;
        return this;
    }

    @Override
    public SitePatchResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.hostnameSslStates() != null) {
            this.hostnameSslStates().forEach(e -> e.validate());
        }
        if (this.siteConfig() != null) {
            this.siteConfig().validate();
        }
        if (this.hostingEnvironmentProfile() != null) {
            this.hostingEnvironmentProfile().validate();
        }
        if (this.cloningInfo() != null) {
            this.cloningInfo().validate();
        }
        if (this.slotSwapStatus() != null) {
            this.slotSwapStatus().validate();
        }
    }
}

