/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.ResponseMessageEnvelopeRemotePrivateEndpointConnection;
import com.azure.resourcemanager.appservice.models.SkuDescription;
import com.azure.resourcemanager.appservice.models.StagingEnvironmentPolicy;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildProperties;
import com.azure.resourcemanager.appservice.models.StaticSiteTemplateOptions;
import com.azure.resourcemanager.appservice.models.StaticSiteUserProvidedFunctionApp;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class StaticSiteArmResourceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(StaticSiteArmResourceInner.class);
    @JsonProperty(value="sku")
    private SkuDescription sku;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="properties.defaultHostname", access=JsonProperty.Access.WRITE_ONLY)
    private String defaultHostname;
    @JsonProperty(value="properties.repositoryUrl")
    private String repositoryUrl;
    @JsonProperty(value="properties.branch")
    private String branch;
    @JsonProperty(value="properties.provider", access=JsonProperty.Access.WRITE_ONLY)
    private String provider;
    @JsonProperty(value="properties.customDomains", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> customDomains;
    @JsonProperty(value="properties.repositoryToken")
    private String repositoryToken;
    @JsonProperty(value="properties.buildProperties")
    private StaticSiteBuildProperties buildProperties;
    @JsonProperty(value="properties.templateProperties")
    private StaticSiteTemplateOptions templateProperties;
    @JsonProperty(value="properties.privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections;
    @JsonProperty(value="properties.contentDistributionEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String contentDistributionEndpoint;
    @JsonProperty(value="properties.keyVaultReferenceIdentity", access=JsonProperty.Access.WRITE_ONLY)
    private String keyVaultReferenceIdentity;
    @JsonProperty(value="properties.userProvidedFunctionApps", access=JsonProperty.Access.WRITE_ONLY)
    private List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps;
    @JsonProperty(value="properties.stagingEnvironmentPolicy")
    private StagingEnvironmentPolicy stagingEnvironmentPolicy;
    @JsonProperty(value="properties.allowConfigFileUpdates")
    private Boolean allowConfigFileUpdates;
    @JsonProperty(value="kind")
    private String kind;

    public SkuDescription sku() {
        return this.sku;
    }

    public StaticSiteArmResourceInner withSku(SkuDescription sku) {
        this.sku = sku;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public StaticSiteArmResourceInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String defaultHostname() {
        return this.defaultHostname;
    }

    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    public StaticSiteArmResourceInner withRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public StaticSiteArmResourceInner withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public String provider() {
        return this.provider;
    }

    public List<String> customDomains() {
        return this.customDomains;
    }

    public String repositoryToken() {
        return this.repositoryToken;
    }

    public StaticSiteArmResourceInner withRepositoryToken(String repositoryToken) {
        this.repositoryToken = repositoryToken;
        return this;
    }

    public StaticSiteBuildProperties buildProperties() {
        return this.buildProperties;
    }

    public StaticSiteArmResourceInner withBuildProperties(StaticSiteBuildProperties buildProperties) {
        this.buildProperties = buildProperties;
        return this;
    }

    public StaticSiteTemplateOptions templateProperties() {
        return this.templateProperties;
    }

    public StaticSiteArmResourceInner withTemplateProperties(StaticSiteTemplateOptions templateProperties) {
        this.templateProperties = templateProperties;
        return this;
    }

    public List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public String contentDistributionEndpoint() {
        return this.contentDistributionEndpoint;
    }

    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    public List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps() {
        return this.userProvidedFunctionApps;
    }

    public StagingEnvironmentPolicy stagingEnvironmentPolicy() {
        return this.stagingEnvironmentPolicy;
    }

    public StaticSiteArmResourceInner withStagingEnvironmentPolicy(StagingEnvironmentPolicy stagingEnvironmentPolicy) {
        this.stagingEnvironmentPolicy = stagingEnvironmentPolicy;
        return this;
    }

    public Boolean allowConfigFileUpdates() {
        return this.allowConfigFileUpdates;
    }

    public StaticSiteArmResourceInner withAllowConfigFileUpdates(Boolean allowConfigFileUpdates) {
        this.allowConfigFileUpdates = allowConfigFileUpdates;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public StaticSiteArmResourceInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public StaticSiteArmResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public StaticSiteArmResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.buildProperties() != null) {
            this.buildProperties().validate();
        }
        if (this.templateProperties() != null) {
            this.templateProperties().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.userProvidedFunctionApps() != null) {
            this.userProvidedFunctionApps().forEach(e -> e.validate());
        }
    }
}

