/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ComputeModeOptions;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.SkuDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class WorkerPoolResourceInner
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WorkerPoolResourceInner.class);
    @JsonProperty(value="sku")
    private SkuDescription sku;
    @JsonProperty(value="properties.workerSizeId")
    private Integer workerSizeId;
    @JsonProperty(value="properties.computeMode")
    private ComputeModeOptions computeMode;
    @JsonProperty(value="properties.workerSize")
    private String workerSize;
    @JsonProperty(value="properties.workerCount")
    private Integer workerCount;
    @JsonProperty(value="properties.instanceNames", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> instanceNames;

    public SkuDescription sku() {
        return this.sku;
    }

    public WorkerPoolResourceInner withSku(SkuDescription sku) {
        this.sku = sku;
        return this;
    }

    public Integer workerSizeId() {
        return this.workerSizeId;
    }

    public WorkerPoolResourceInner withWorkerSizeId(Integer workerSizeId) {
        this.workerSizeId = workerSizeId;
        return this;
    }

    public ComputeModeOptions computeMode() {
        return this.computeMode;
    }

    public WorkerPoolResourceInner withComputeMode(ComputeModeOptions computeMode) {
        this.computeMode = computeMode;
        return this;
    }

    public String workerSize() {
        return this.workerSize;
    }

    public WorkerPoolResourceInner withWorkerSize(String workerSize) {
        this.workerSize = workerSize;
        return this;
    }

    public Integer workerCount() {
        return this.workerCount;
    }

    public WorkerPoolResourceInner withWorkerCount(Integer workerCount) {
        this.workerCount = workerCount;
        return this;
    }

    public List<String> instanceNames() {
        return this.instanceNames;
    }

    @Override
    public WorkerPoolResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

