/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePatchResourceInner;
import com.azure.resourcemanager.appservice.implementation.DeploymentSlotBaseImpl;
import com.azure.resourcemanager.appservice.implementation.FunctionAppImpl;
import com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import reactor.core.publisher.Mono;

class FunctionDeploymentSlotImpl
extends DeploymentSlotBaseImpl<FunctionDeploymentSlot, FunctionDeploymentSlotImpl, FunctionAppImpl, FunctionDeploymentSlot.DefinitionStages.WithCreate, DeploymentSlotBase<FunctionDeploymentSlot>>
implements FunctionDeploymentSlot,
FunctionDeploymentSlot.Definition {
    FunctionDeploymentSlotImpl(String name, SiteInner innerObject, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig, FunctionAppImpl parent) {
        super(name, innerObject, siteConfig, logConfig, parent);
    }

    @Override
    public FunctionDeploymentSlot.DefinitionStages.WithCreate withConfigurationFromParent() {
        return this.withConfigurationFromFunctionApp((FunctionApp)this.parent());
    }

    @Override
    public FunctionDeploymentSlot.DefinitionStages.WithCreate withConfigurationFromFunctionApp(FunctionApp app) {
        this.siteConfig = ((WebAppBaseImpl)((Object)app)).siteConfig;
        this.configurationSource = app;
        return this;
    }

    @Override
    public void zipDeploy(File zipFile) {
        this.zipDeployAsync(zipFile).block();
    }

    @Override
    public void zipDeploy(InputStream zipFile, long length) {
        this.zipDeployAsync(zipFile, length).block();
    }

    @Override
    public Mono<Void> zipDeployAsync(InputStream zipFile, long length) {
        return this.kuduClient.zipDeployAsync(zipFile, length);
    }

    @Override
    public Mono<Void> zipDeployAsync(File zipFile) {
        try {
            return this.kuduClient.zipDeployAsync(zipFile);
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    Mono<SiteInner> submitSite(SiteInner site) {
        return this.submitSiteWithoutSiteConfig(site);
    }

    @Override
    Mono<SiteInner> submitSite(SitePatchResourceInner siteUpdate) {
        return this.submitSiteWithoutSiteConfig((SiteInner)((Object)this.innerModel()));
    }
}

