/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.StackMajorVersion;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ApplicationStack {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ApplicationStack.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="display")
    private String display;
    @JsonProperty(value="dependency")
    private String dependency;
    @JsonProperty(value="majorVersions")
    private List<StackMajorVersion> majorVersions;
    @JsonProperty(value="frameworks")
    private List<ApplicationStack> frameworks;
    @JsonProperty(value="isDeprecated")
    private List<ApplicationStack> isDeprecated;

    public String name() {
        return this.name;
    }

    public ApplicationStack withName(String name) {
        this.name = name;
        return this;
    }

    public String display() {
        return this.display;
    }

    public ApplicationStack withDisplay(String display) {
        this.display = display;
        return this;
    }

    public String dependency() {
        return this.dependency;
    }

    public ApplicationStack withDependency(String dependency) {
        this.dependency = dependency;
        return this;
    }

    public List<StackMajorVersion> majorVersions() {
        return this.majorVersions;
    }

    public ApplicationStack withMajorVersions(List<StackMajorVersion> majorVersions) {
        this.majorVersions = majorVersions;
        return this;
    }

    public List<ApplicationStack> frameworks() {
        return this.frameworks;
    }

    public ApplicationStack withFrameworks(List<ApplicationStack> frameworks) {
        this.frameworks = frameworks;
        return this;
    }

    public List<ApplicationStack> isDeprecated() {
        return this.isDeprecated;
    }

    public ApplicationStack withIsDeprecated(List<ApplicationStack> isDeprecated) {
        this.isDeprecated = isDeprecated;
        return this;
    }

    public void validate() {
        if (this.majorVersions() != null) {
            this.majorVersions().forEach(e -> e.validate());
        }
        if (this.frameworks() != null) {
            this.frameworks().forEach(e -> e.validate());
        }
        if (this.isDeprecated() != null) {
            this.isDeprecated().forEach(e -> e.validate());
        }
    }
}

