/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.RequestsBasedTrigger;
import com.azure.resourcemanager.appservice.models.SlowRequestsBasedTrigger;
import com.azure.resourcemanager.appservice.models.StatusCodesBasedTrigger;
import com.azure.resourcemanager.appservice.models.StatusCodesRangeBasedTrigger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AutoHealTriggers {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AutoHealTriggers.class);
    @JsonProperty(value="requests")
    private RequestsBasedTrigger requests;
    @JsonProperty(value="privateBytesInKB")
    private Integer privateBytesInKB;
    @JsonProperty(value="statusCodes")
    private List<StatusCodesBasedTrigger> statusCodes;
    @JsonProperty(value="statusCodesRange")
    private List<StatusCodesRangeBasedTrigger> statusCodesRange;
    @JsonProperty(value="slowRequests")
    private SlowRequestsBasedTrigger slowRequests;
    @JsonProperty(value="slowRequestsWithPath")
    private List<SlowRequestsBasedTrigger> slowRequestsWithPath;

    public RequestsBasedTrigger requests() {
        return this.requests;
    }

    public AutoHealTriggers withRequests(RequestsBasedTrigger requests) {
        this.requests = requests;
        return this;
    }

    public Integer privateBytesInKB() {
        return this.privateBytesInKB;
    }

    public AutoHealTriggers withPrivateBytesInKB(Integer privateBytesInKB) {
        this.privateBytesInKB = privateBytesInKB;
        return this;
    }

    public List<StatusCodesBasedTrigger> statusCodes() {
        return this.statusCodes;
    }

    public AutoHealTriggers withStatusCodes(List<StatusCodesBasedTrigger> statusCodes) {
        this.statusCodes = statusCodes;
        return this;
    }

    public List<StatusCodesRangeBasedTrigger> statusCodesRange() {
        return this.statusCodesRange;
    }

    public AutoHealTriggers withStatusCodesRange(List<StatusCodesRangeBasedTrigger> statusCodesRange) {
        this.statusCodesRange = statusCodesRange;
        return this;
    }

    public SlowRequestsBasedTrigger slowRequests() {
        return this.slowRequests;
    }

    public AutoHealTriggers withSlowRequests(SlowRequestsBasedTrigger slowRequests) {
        this.slowRequests = slowRequests;
        return this;
    }

    public List<SlowRequestsBasedTrigger> slowRequestsWithPath() {
        return this.slowRequestsWithPath;
    }

    public AutoHealTriggers withSlowRequestsWithPath(List<SlowRequestsBasedTrigger> slowRequestsWithPath) {
        this.slowRequestsWithPath = slowRequestsWithPath;
        return this;
    }

    public void validate() {
        if (this.requests() != null) {
            this.requests().validate();
        }
        if (this.statusCodes() != null) {
            this.statusCodes().forEach(e -> e.validate());
        }
        if (this.statusCodesRange() != null) {
            this.statusCodesRange().forEach(e -> e.validate());
        }
        if (this.slowRequests() != null) {
            this.slowRequests().validate();
        }
        if (this.slowRequestsWithPath() != null) {
            this.slowRequestsWithPath().forEach(e -> e.validate());
        }
    }
}

