/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.AzureActiveDirectoryLogin;
import com.azure.resourcemanager.appservice.models.AzureActiveDirectoryRegistration;
import com.azure.resourcemanager.appservice.models.AzureActiveDirectoryValidation;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class AzureActiveDirectory
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AzureActiveDirectory.class);
    @JsonProperty(value="properties.enabled")
    private Boolean enabled;
    @JsonProperty(value="properties.registration")
    private AzureActiveDirectoryRegistration registration;
    @JsonProperty(value="properties.login")
    private AzureActiveDirectoryLogin login;
    @JsonProperty(value="properties.validation")
    private AzureActiveDirectoryValidation validation;
    @JsonProperty(value="properties.isAutoProvisioned")
    private Boolean isAutoProvisioned;

    public Boolean enabled() {
        return this.enabled;
    }

    public AzureActiveDirectory withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AzureActiveDirectoryRegistration registration() {
        return this.registration;
    }

    public AzureActiveDirectory withRegistration(AzureActiveDirectoryRegistration registration) {
        this.registration = registration;
        return this;
    }

    public AzureActiveDirectoryLogin login() {
        return this.login;
    }

    public AzureActiveDirectory withLogin(AzureActiveDirectoryLogin login) {
        this.login = login;
        return this;
    }

    public AzureActiveDirectoryValidation validation() {
        return this.validation;
    }

    public AzureActiveDirectory withValidation(AzureActiveDirectoryValidation validation) {
        this.validation = validation;
        return this;
    }

    public Boolean isAutoProvisioned() {
        return this.isAutoProvisioned;
    }

    public AzureActiveDirectory withIsAutoProvisioned(Boolean isAutoProvisioned) {
        this.isAutoProvisioned = isAutoProvisioned;
        return this;
    }

    @Override
    public AzureActiveDirectory withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.registration() != null) {
            this.registration().validate();
        }
        if (this.login() != null) {
            this.login().validate();
        }
        if (this.validation() != null) {
            this.validation().validate();
        }
    }
}

