/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.OpenIdConnectLogin;
import com.azure.resourcemanager.appservice.models.OpenIdConnectRegistration;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class CustomOpenIdConnectProvider
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CustomOpenIdConnectProvider.class);
    @JsonProperty(value="properties.enabled")
    private Boolean enabled;
    @JsonProperty(value="properties.registration")
    private OpenIdConnectRegistration registration;
    @JsonProperty(value="properties.login")
    private OpenIdConnectLogin login;

    public Boolean enabled() {
        return this.enabled;
    }

    public CustomOpenIdConnectProvider withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OpenIdConnectRegistration registration() {
        return this.registration;
    }

    public CustomOpenIdConnectProvider withRegistration(OpenIdConnectRegistration registration) {
        this.registration = registration;
        return this;
    }

    public OpenIdConnectLogin login() {
        return this.login;
    }

    public CustomOpenIdConnectProvider withLogin(OpenIdConnectLogin login) {
        this.login = login;
        return this;
    }

    @Override
    public CustomOpenIdConnectProvider withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.registration() != null) {
            this.registration().validate();
        }
        if (this.login() != null) {
            this.login().validate();
        }
    }
}

