/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.Contact;
import com.azure.resourcemanager.appservice.models.DnsType;
import com.azure.resourcemanager.appservice.models.DomainPatchResourcePropertiesDomainNotRenewableReasonsItem;
import com.azure.resourcemanager.appservice.models.DomainPurchaseConsent;
import com.azure.resourcemanager.appservice.models.DomainStatus;
import com.azure.resourcemanager.appservice.models.Hostname;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

@JsonFlatten
public class DomainPatchResource
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DomainPatchResource.class);
    @JsonProperty(value="properties.contactAdmin")
    private Contact contactAdmin;
    @JsonProperty(value="properties.contactBilling")
    private Contact contactBilling;
    @JsonProperty(value="properties.contactRegistrant")
    private Contact contactRegistrant;
    @JsonProperty(value="properties.contactTech")
    private Contact contactTech;
    @JsonProperty(value="properties.registrationStatus", access=JsonProperty.Access.WRITE_ONLY)
    private DomainStatus registrationStatus;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.nameServers", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> nameServers;
    @JsonProperty(value="properties.privacy")
    private Boolean privacy;
    @JsonProperty(value="properties.createdTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdTime;
    @JsonProperty(value="properties.expirationTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime expirationTime;
    @JsonProperty(value="properties.lastRenewedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastRenewedTime;
    @JsonProperty(value="properties.autoRenew")
    private Boolean autoRenew;
    @JsonProperty(value="properties.readyForDnsRecordManagement", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean readyForDnsRecordManagement;
    @JsonProperty(value="properties.managedHostNames", access=JsonProperty.Access.WRITE_ONLY)
    private List<Hostname> managedHostNames;
    @JsonProperty(value="properties.consent")
    private DomainPurchaseConsent consent;
    @JsonProperty(value="properties.domainNotRenewableReasons", access=JsonProperty.Access.WRITE_ONLY)
    private List<DomainPatchResourcePropertiesDomainNotRenewableReasonsItem> domainNotRenewableReasons;
    @JsonProperty(value="properties.dnsType")
    private DnsType dnsType;
    @JsonProperty(value="properties.dnsZoneId")
    private String dnsZoneId;
    @JsonProperty(value="properties.targetDnsType")
    private DnsType targetDnsType;
    @JsonProperty(value="properties.authCode")
    private String authCode;

    public Contact contactAdmin() {
        return this.contactAdmin;
    }

    public DomainPatchResource withContactAdmin(Contact contactAdmin) {
        this.contactAdmin = contactAdmin;
        return this;
    }

    public Contact contactBilling() {
        return this.contactBilling;
    }

    public DomainPatchResource withContactBilling(Contact contactBilling) {
        this.contactBilling = contactBilling;
        return this;
    }

    public Contact contactRegistrant() {
        return this.contactRegistrant;
    }

    public DomainPatchResource withContactRegistrant(Contact contactRegistrant) {
        this.contactRegistrant = contactRegistrant;
        return this;
    }

    public Contact contactTech() {
        return this.contactTech;
    }

    public DomainPatchResource withContactTech(Contact contactTech) {
        this.contactTech = contactTech;
        return this;
    }

    public DomainStatus registrationStatus() {
        return this.registrationStatus;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<String> nameServers() {
        return this.nameServers;
    }

    public Boolean privacy() {
        return this.privacy;
    }

    public DomainPatchResource withPrivacy(Boolean privacy) {
        this.privacy = privacy;
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime expirationTime() {
        return this.expirationTime;
    }

    public OffsetDateTime lastRenewedTime() {
        return this.lastRenewedTime;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public DomainPatchResource withAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    public Boolean readyForDnsRecordManagement() {
        return this.readyForDnsRecordManagement;
    }

    public List<Hostname> managedHostNames() {
        return this.managedHostNames;
    }

    public DomainPurchaseConsent consent() {
        return this.consent;
    }

    public DomainPatchResource withConsent(DomainPurchaseConsent consent) {
        this.consent = consent;
        return this;
    }

    public List<DomainPatchResourcePropertiesDomainNotRenewableReasonsItem> domainNotRenewableReasons() {
        return this.domainNotRenewableReasons;
    }

    public DnsType dnsType() {
        return this.dnsType;
    }

    public DomainPatchResource withDnsType(DnsType dnsType) {
        this.dnsType = dnsType;
        return this;
    }

    public String dnsZoneId() {
        return this.dnsZoneId;
    }

    public DomainPatchResource withDnsZoneId(String dnsZoneId) {
        this.dnsZoneId = dnsZoneId;
        return this;
    }

    public DnsType targetDnsType() {
        return this.targetDnsType;
    }

    public DomainPatchResource withTargetDnsType(DnsType targetDnsType) {
        this.targetDnsType = targetDnsType;
        return this;
    }

    public String authCode() {
        return this.authCode;
    }

    public DomainPatchResource withAuthCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    @Override
    public DomainPatchResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.contactAdmin() != null) {
            this.contactAdmin().validate();
        }
        if (this.contactBilling() != null) {
            this.contactBilling().validate();
        }
        if (this.contactRegistrant() != null) {
            this.contactRegistrant().validate();
        }
        if (this.contactTech() != null) {
            this.contactTech().validate();
        }
        if (this.managedHostNames() != null) {
            this.managedHostNames().forEach(e -> e.validate());
        }
        if (this.consent() != null) {
            this.consent().validate();
        }
    }
}

