/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ForwardProxy;
import com.azure.resourcemanager.appservice.models.HttpSettingsRoutes;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class HttpSettings
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(HttpSettings.class);
    @JsonProperty(value="properties.requireHttps")
    private Boolean requireHttps;
    @JsonProperty(value="properties.routes")
    private HttpSettingsRoutes routes;
    @JsonProperty(value="properties.forwardProxy")
    private ForwardProxy forwardProxy;

    public Boolean requireHttps() {
        return this.requireHttps;
    }

    public HttpSettings withRequireHttps(Boolean requireHttps) {
        this.requireHttps = requireHttps;
        return this;
    }

    public HttpSettingsRoutes routes() {
        return this.routes;
    }

    public HttpSettings withRoutes(HttpSettingsRoutes routes) {
        this.routes = routes;
        return this;
    }

    public ForwardProxy forwardProxy() {
        return this.forwardProxy;
    }

    public HttpSettings withForwardProxy(ForwardProxy forwardProxy) {
        this.forwardProxy = forwardProxy;
        return this;
    }

    @Override
    public HttpSettings withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.routes() != null) {
            this.routes().validate();
        }
        if (this.forwardProxy() != null) {
            this.forwardProxy().validate();
        }
    }
}

