/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.Apple;
import com.azure.resourcemanager.appservice.models.AzureActiveDirectory;
import com.azure.resourcemanager.appservice.models.AzureStaticWebApps;
import com.azure.resourcemanager.appservice.models.CustomOpenIdConnectProvider;
import com.azure.resourcemanager.appservice.models.Facebook;
import com.azure.resourcemanager.appservice.models.GitHub;
import com.azure.resourcemanager.appservice.models.Google;
import com.azure.resourcemanager.appservice.models.LegacyMicrosoftAccount;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.Twitter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class IdentityProviders
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(IdentityProviders.class);
    @JsonProperty(value="properties.azureActiveDirectory")
    private AzureActiveDirectory azureActiveDirectory;
    @JsonProperty(value="properties.facebook")
    private Facebook facebook;
    @JsonProperty(value="properties.gitHub")
    private GitHub gitHub;
    @JsonProperty(value="properties.google")
    private Google google;
    @JsonProperty(value="properties.legacyMicrosoftAccount")
    private LegacyMicrosoftAccount legacyMicrosoftAccount;
    @JsonProperty(value="properties.twitter")
    private Twitter twitter;
    @JsonProperty(value="properties.apple")
    private Apple apple;
    @JsonProperty(value="properties.azureStaticWebApps")
    private AzureStaticWebApps azureStaticWebApps;
    @JsonProperty(value="properties.customOpenIdConnectProviders")
    private Map<String, CustomOpenIdConnectProvider> customOpenIdConnectProviders;

    public AzureActiveDirectory azureActiveDirectory() {
        return this.azureActiveDirectory;
    }

    public IdentityProviders withAzureActiveDirectory(AzureActiveDirectory azureActiveDirectory) {
        this.azureActiveDirectory = azureActiveDirectory;
        return this;
    }

    public Facebook facebook() {
        return this.facebook;
    }

    public IdentityProviders withFacebook(Facebook facebook) {
        this.facebook = facebook;
        return this;
    }

    public GitHub gitHub() {
        return this.gitHub;
    }

    public IdentityProviders withGitHub(GitHub gitHub) {
        this.gitHub = gitHub;
        return this;
    }

    public Google google() {
        return this.google;
    }

    public IdentityProviders withGoogle(Google google) {
        this.google = google;
        return this;
    }

    public LegacyMicrosoftAccount legacyMicrosoftAccount() {
        return this.legacyMicrosoftAccount;
    }

    public IdentityProviders withLegacyMicrosoftAccount(LegacyMicrosoftAccount legacyMicrosoftAccount) {
        this.legacyMicrosoftAccount = legacyMicrosoftAccount;
        return this;
    }

    public Twitter twitter() {
        return this.twitter;
    }

    public IdentityProviders withTwitter(Twitter twitter) {
        this.twitter = twitter;
        return this;
    }

    public Apple apple() {
        return this.apple;
    }

    public IdentityProviders withApple(Apple apple) {
        this.apple = apple;
        return this;
    }

    public AzureStaticWebApps azureStaticWebApps() {
        return this.azureStaticWebApps;
    }

    public IdentityProviders withAzureStaticWebApps(AzureStaticWebApps azureStaticWebApps) {
        this.azureStaticWebApps = azureStaticWebApps;
        return this;
    }

    public Map<String, CustomOpenIdConnectProvider> customOpenIdConnectProviders() {
        return this.customOpenIdConnectProviders;
    }

    public IdentityProviders withCustomOpenIdConnectProviders(Map<String, CustomOpenIdConnectProvider> customOpenIdConnectProviders) {
        this.customOpenIdConnectProviders = customOpenIdConnectProviders;
        return this;
    }

    @Override
    public IdentityProviders withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.azureActiveDirectory() != null) {
            this.azureActiveDirectory().validate();
        }
        if (this.facebook() != null) {
            this.facebook().validate();
        }
        if (this.gitHub() != null) {
            this.gitHub().validate();
        }
        if (this.google() != null) {
            this.google().validate();
        }
        if (this.legacyMicrosoftAccount() != null) {
            this.legacyMicrosoftAccount().validate();
        }
        if (this.twitter() != null) {
            this.twitter().validate();
        }
        if (this.apple() != null) {
            this.apple().validate();
        }
        if (this.azureStaticWebApps() != null) {
            this.azureStaticWebApps().validate();
        }
        if (this.customOpenIdConnectProviders() != null) {
            this.customOpenIdConnectProviders().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

