/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.CookieExpiration;
import com.azure.resourcemanager.appservice.models.LoginRoutes;
import com.azure.resourcemanager.appservice.models.Nonce;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.TokenStore;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class Login
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Login.class);
    @JsonProperty(value="properties.routes")
    private LoginRoutes routes;
    @JsonProperty(value="properties.tokenStore")
    private TokenStore tokenStore;
    @JsonProperty(value="properties.preserveUrlFragmentsForLogins")
    private Boolean preserveUrlFragmentsForLogins;
    @JsonProperty(value="properties.allowedExternalRedirectUrls")
    private List<String> allowedExternalRedirectUrls;
    @JsonProperty(value="properties.cookieExpiration")
    private CookieExpiration cookieExpiration;
    @JsonProperty(value="properties.nonce")
    private Nonce nonce;

    public LoginRoutes routes() {
        return this.routes;
    }

    public Login withRoutes(LoginRoutes routes) {
        this.routes = routes;
        return this;
    }

    public TokenStore tokenStore() {
        return this.tokenStore;
    }

    public Login withTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
        return this;
    }

    public Boolean preserveUrlFragmentsForLogins() {
        return this.preserveUrlFragmentsForLogins;
    }

    public Login withPreserveUrlFragmentsForLogins(Boolean preserveUrlFragmentsForLogins) {
        this.preserveUrlFragmentsForLogins = preserveUrlFragmentsForLogins;
        return this;
    }

    public List<String> allowedExternalRedirectUrls() {
        return this.allowedExternalRedirectUrls;
    }

    public Login withAllowedExternalRedirectUrls(List<String> allowedExternalRedirectUrls) {
        this.allowedExternalRedirectUrls = allowedExternalRedirectUrls;
        return this;
    }

    public CookieExpiration cookieExpiration() {
        return this.cookieExpiration;
    }

    public Login withCookieExpiration(CookieExpiration cookieExpiration) {
        this.cookieExpiration = cookieExpiration;
        return this;
    }

    public Nonce nonce() {
        return this.nonce;
    }

    public Login withNonce(Nonce nonce) {
        this.nonce = nonce;
        return this;
    }

    @Override
    public Login withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.routes() != null) {
            this.routes().validate();
        }
        if (this.tokenStore() != null) {
            this.tokenStore().validate();
        }
        if (this.cookieExpiration() != null) {
            this.cookieExpiration().validate();
        }
        if (this.nonce() != null) {
            this.nonce().validate();
        }
    }
}

