// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentStatus;
import com.azure.resourcemanager.appservice.models.LoadBalancingMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.UpgradeAvailability;
import com.azure.resourcemanager.appservice.models.UpgradePreference;
import com.azure.resourcemanager.appservice.models.VirtualNetworkProfile;
import java.io.IOException;
import java.util.List;

/**
 * Description of an App Service Environment.
 */
@Fluent
public final class AppServiceEnvironmentInner implements JsonSerializable<AppServiceEnvironmentInner> {
    /*
     * Provisioning state of the App Service Environment.
     */
    private ProvisioningState provisioningState;

    /*
     * Current status of the App Service Environment.
     */
    private HostingEnvironmentStatus status;

    /*
     * Description of the Virtual Network.
     */
    private VirtualNetworkProfile virtualNetwork;

    /*
     * Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment.
     */
    private LoadBalancingMode internalLoadBalancingMode;

    /*
     * Front-end VM size, e.g. "Medium", "Large".
     */
    private String multiSize;

    /*
     * Number of front-end instances.
     */
    private Integer multiRoleCount;

    /*
     * Number of IP SSL addresses reserved for the App Service Environment.
     */
    private Integer ipsslAddressCount;

    /*
     * DNS suffix of the App Service Environment.
     */
    private String dnsSuffix;

    /*
     * Maximum number of VMs in the App Service Environment.
     */
    private Integer maximumNumberOfMachines;

    /*
     * Scale factor for front-ends.
     */
    private Integer frontEndScaleFactor;

    /*
     * <code>true</code> if the App Service Environment is suspended; otherwise, <code>false</code>. The environment can
     * be suspended, e.g. when the management endpoint is no longer available
     * (most likely because NSG blocked the incoming traffic).
     */
    private Boolean suspended;

    /*
     * Custom settings for changing the behavior of the App Service Environment.
     */
    private List<NameValuePair> clusterSettings;

    /*
     * User added ip ranges to whitelist on ASE db
     */
    private List<String> userWhitelistedIpRanges;

    /*
     * Flag that displays whether an ASE has linux workers or not
     */
    private Boolean hasLinuxWorkers;

    /*
     * Upgrade Preference
     */
    private UpgradePreference upgradePreference;

    /*
     * Dedicated Host Count
     */
    private Integer dedicatedHostCount;

    /*
     * Whether or not this App Service Environment is zone-redundant.
     */
    private Boolean zoneRedundant;

    /*
     * Full view of the custom domain suffix configuration for ASEv3.
     */
    private CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration;

    /*
     * Full view of networking configuration for an ASE.
     */
    private AseV3NetworkingConfigurationInner networkingConfiguration;

    /*
     * Whether an upgrade is available for this App Service Environment.
     */
    private UpgradeAvailability upgradeAvailability;

    /**
     * Creates an instance of AppServiceEnvironmentInner class.
     */
    public AppServiceEnvironmentInner() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the App Service Environment.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the status property: Current status of the App Service Environment.
     * 
     * @return the status value.
     */
    public HostingEnvironmentStatus status() {
        return this.status;
    }

    /**
     * Get the virtualNetwork property: Description of the Virtual Network.
     * 
     * @return the virtualNetwork value.
     */
    public VirtualNetworkProfile virtualNetwork() {
        return this.virtualNetwork;
    }

    /**
     * Set the virtualNetwork property: Description of the Virtual Network.
     * 
     * @param virtualNetwork the virtualNetwork value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner withVirtualNetwork(VirtualNetworkProfile virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    /**
     * Get the internalLoadBalancingMode property: Specifies which endpoints to serve internally in the Virtual Network
     * for the App Service Environment.
     * 
     * @return the internalLoadBalancingMode value.
     */
    public LoadBalancingMode internalLoadBalancingMode() {
        return this.internalLoadBalancingMode;
    }

    /**
     * Set the internalLoadBalancingMode property: Specifies which endpoints to serve internally in the Virtual Network
     * for the App Service Environment.
     * 
     * @param internalLoadBalancingMode the internalLoadBalancingMode value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner withInternalLoadBalancingMode(LoadBalancingMode internalLoadBalancingMode) {
        this.internalLoadBalancingMode = internalLoadBalancingMode;
        return this;
    }

    /**
     * Get the multiSize property: Front-end VM size, e.g. "Medium", "Large".
     * 
     * @return the multiSize value.
     */
    public String multiSize() {
        return this.multiSize;
    }

    /**
     * Set the multiSize property: Front-end VM size, e.g. "Medium", "Large".
     * 
     * @param multiSize the multiSize value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner withMultiSize(String multiSize) {
        this.multiSize = multiSize;
        return this;
    }

    /**
     * Get the multiRoleCount property: Number of front-end instances.
     * 
     * @return the multiRoleCount value.
     */
    public Integer multiRoleCount() {
        return this.multiRoleCount;
    }

    /**
     * Get the ipsslAddressCount property: Number of IP SSL addresses reserved for the App Service Environment.
     * 
     * @return the ipsslAddressCount value.
     */
    public Integer ipsslAddressCount() {
        return this.ipsslAddressCount;
    }

    /**
     * Set the ipsslAddressCount property: Number of IP SSL addresses reserved for the App Service Environment.
     * 
     * @param ipsslAddressCount the ipsslAddressCount value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner withIpsslAddressCount(Integer ipsslAddressCount) {
        this.ipsslAddressCount = ipsslAddressCount;
        return this;
    }

    /**
     * Get the dnsSuffix property: DNS suffix of the App Service Environment.
     * 
     * @return the dnsSuffix value.
     */
    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    /**
     * Set the dnsSuffix property: DNS suffix of the App Service Environment.
     * 
     * @param dnsSuffix the dnsSuffix value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner withDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
        return this;
    }

    /**
     * Get the maximumNumberOfMachines property: Maximum number of VMs in the App Service Environment.
     * 
     * @return the maximumNumberOfMachines value.
     */
    public Integer maximumNumberOfMachines() {
        return this.maximumNumberOfMachines;
    }

    /**
     * Get the frontEndScaleFactor property: Scale factor for front-ends.
     * 
     * @return the frontEndScaleFactor value.
     */
    public Integer frontEndScaleFactor() {
        return this.frontEndScaleFactor;
    }

    /**
     * Set the frontEndScaleFactor property: Scale factor for front-ends.
     * 
     * @param frontEndScaleFactor the frontEndScaleFactor value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner withFrontEndScaleFactor(Integer frontEndScaleFactor) {
        this.frontEndScaleFactor = frontEndScaleFactor;
        return this;
    }

    /**
     * Get the suspended property: &lt;code&gt;true&lt;/code&gt; if the App Service Environment is suspended; otherwise,
     * &lt;code&gt;false&lt;/code&gt;. The environment can be suspended, e.g. when the management endpoint is no longer
     * available
     * (most likely because NSG blocked the incoming traffic).
     * 
     * @return the suspended value.
     */
    public Boolean suspended() {
        return this.suspended;
    }

    /**
     * Get the clusterSettings property: Custom settings for changing the behavior of the App Service Environment.
     * 
     * @return the clusterSettings value.
     */
    public List<NameValuePair> clusterSettings() {
        return this.clusterSettings;
    }

    /**
     * Set the clusterSettings property: Custom settings for changing the behavior of the App Service Environment.
     * 
     * @param clusterSettings the clusterSettings value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner withClusterSettings(List<NameValuePair> clusterSettings) {
        this.clusterSettings = clusterSettings;
        return this;
    }

    /**
     * Get the userWhitelistedIpRanges property: User added ip ranges to whitelist on ASE db.
     * 
     * @return the userWhitelistedIpRanges value.
     */
    public List<String> userWhitelistedIpRanges() {
        return this.userWhitelistedIpRanges;
    }

    /**
     * Set the userWhitelistedIpRanges property: User added ip ranges to whitelist on ASE db.
     * 
     * @param userWhitelistedIpRanges the userWhitelistedIpRanges value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner withUserWhitelistedIpRanges(List<String> userWhitelistedIpRanges) {
        this.userWhitelistedIpRanges = userWhitelistedIpRanges;
        return this;
    }

    /**
     * Get the hasLinuxWorkers property: Flag that displays whether an ASE has linux workers or not.
     * 
     * @return the hasLinuxWorkers value.
     */
    public Boolean hasLinuxWorkers() {
        return this.hasLinuxWorkers;
    }

    /**
     * Get the upgradePreference property: Upgrade Preference.
     * 
     * @return the upgradePreference value.
     */
    public UpgradePreference upgradePreference() {
        return this.upgradePreference;
    }

    /**
     * Set the upgradePreference property: Upgrade Preference.
     * 
     * @param upgradePreference the upgradePreference value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner withUpgradePreference(UpgradePreference upgradePreference) {
        this.upgradePreference = upgradePreference;
        return this;
    }

    /**
     * Get the dedicatedHostCount property: Dedicated Host Count.
     * 
     * @return the dedicatedHostCount value.
     */
    public Integer dedicatedHostCount() {
        return this.dedicatedHostCount;
    }

    /**
     * Set the dedicatedHostCount property: Dedicated Host Count.
     * 
     * @param dedicatedHostCount the dedicatedHostCount value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner withDedicatedHostCount(Integer dedicatedHostCount) {
        this.dedicatedHostCount = dedicatedHostCount;
        return this;
    }

    /**
     * Get the zoneRedundant property: Whether or not this App Service Environment is zone-redundant.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    /**
     * Set the zoneRedundant property: Whether or not this App Service Environment is zone-redundant.
     * 
     * @param zoneRedundant the zoneRedundant value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    /**
     * Get the customDnsSuffixConfiguration property: Full view of the custom domain suffix configuration for ASEv3.
     * 
     * @return the customDnsSuffixConfiguration value.
     */
    public CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration() {
        return this.customDnsSuffixConfiguration;
    }

    /**
     * Set the customDnsSuffixConfiguration property: Full view of the custom domain suffix configuration for ASEv3.
     * 
     * @param customDnsSuffixConfiguration the customDnsSuffixConfiguration value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner
        withCustomDnsSuffixConfiguration(CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration) {
        this.customDnsSuffixConfiguration = customDnsSuffixConfiguration;
        return this;
    }

    /**
     * Get the networkingConfiguration property: Full view of networking configuration for an ASE.
     * 
     * @return the networkingConfiguration value.
     */
    public AseV3NetworkingConfigurationInner networkingConfiguration() {
        return this.networkingConfiguration;
    }

    /**
     * Set the networkingConfiguration property: Full view of networking configuration for an ASE.
     * 
     * @param networkingConfiguration the networkingConfiguration value to set.
     * @return the AppServiceEnvironmentInner object itself.
     */
    public AppServiceEnvironmentInner
        withNetworkingConfiguration(AseV3NetworkingConfigurationInner networkingConfiguration) {
        this.networkingConfiguration = networkingConfiguration;
        return this;
    }

    /**
     * Get the upgradeAvailability property: Whether an upgrade is available for this App Service Environment.
     * 
     * @return the upgradeAvailability value.
     */
    public UpgradeAvailability upgradeAvailability() {
        return this.upgradeAvailability;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (virtualNetwork() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property virtualNetwork in model AppServiceEnvironmentInner"));
        } else {
            virtualNetwork().validate();
        }
        if (clusterSettings() != null) {
            clusterSettings().forEach(e -> e.validate());
        }
        if (customDnsSuffixConfiguration() != null) {
            customDnsSuffixConfiguration().validate();
        }
        if (networkingConfiguration() != null) {
            networkingConfiguration().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AppServiceEnvironmentInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualNetwork", this.virtualNetwork);
        jsonWriter.writeStringField("internalLoadBalancingMode",
            this.internalLoadBalancingMode == null ? null : this.internalLoadBalancingMode.toString());
        jsonWriter.writeStringField("multiSize", this.multiSize);
        jsonWriter.writeNumberField("ipsslAddressCount", this.ipsslAddressCount);
        jsonWriter.writeStringField("dnsSuffix", this.dnsSuffix);
        jsonWriter.writeNumberField("frontEndScaleFactor", this.frontEndScaleFactor);
        jsonWriter.writeArrayField("clusterSettings", this.clusterSettings,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("userWhitelistedIpRanges", this.userWhitelistedIpRanges,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("upgradePreference",
            this.upgradePreference == null ? null : this.upgradePreference.toString());
        jsonWriter.writeNumberField("dedicatedHostCount", this.dedicatedHostCount);
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeJsonField("customDnsSuffixConfiguration", this.customDnsSuffixConfiguration);
        jsonWriter.writeJsonField("networkingConfiguration", this.networkingConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppServiceEnvironmentInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppServiceEnvironmentInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AppServiceEnvironmentInner.
     */
    public static AppServiceEnvironmentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppServiceEnvironmentInner deserializedAppServiceEnvironmentInner = new AppServiceEnvironmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("virtualNetwork".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.virtualNetwork = VirtualNetworkProfile.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("status".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.status
                        = HostingEnvironmentStatus.fromString(reader.getString());
                } else if ("internalLoadBalancingMode".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.internalLoadBalancingMode
                        = LoadBalancingMode.fromString(reader.getString());
                } else if ("multiSize".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.multiSize = reader.getString();
                } else if ("multiRoleCount".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.multiRoleCount = reader.getNullable(JsonReader::getInt);
                } else if ("ipsslAddressCount".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.ipsslAddressCount = reader.getNullable(JsonReader::getInt);
                } else if ("dnsSuffix".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.dnsSuffix = reader.getString();
                } else if ("maximumNumberOfMachines".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.maximumNumberOfMachines
                        = reader.getNullable(JsonReader::getInt);
                } else if ("frontEndScaleFactor".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.frontEndScaleFactor = reader.getNullable(JsonReader::getInt);
                } else if ("suspended".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.suspended = reader.getNullable(JsonReader::getBoolean);
                } else if ("clusterSettings".equals(fieldName)) {
                    List<NameValuePair> clusterSettings = reader.readArray(reader1 -> NameValuePair.fromJson(reader1));
                    deserializedAppServiceEnvironmentInner.clusterSettings = clusterSettings;
                } else if ("userWhitelistedIpRanges".equals(fieldName)) {
                    List<String> userWhitelistedIpRanges = reader.readArray(reader1 -> reader1.getString());
                    deserializedAppServiceEnvironmentInner.userWhitelistedIpRanges = userWhitelistedIpRanges;
                } else if ("hasLinuxWorkers".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.hasLinuxWorkers = reader.getNullable(JsonReader::getBoolean);
                } else if ("upgradePreference".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.upgradePreference
                        = UpgradePreference.fromString(reader.getString());
                } else if ("dedicatedHostCount".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.dedicatedHostCount = reader.getNullable(JsonReader::getInt);
                } else if ("zoneRedundant".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.zoneRedundant = reader.getNullable(JsonReader::getBoolean);
                } else if ("customDnsSuffixConfiguration".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.customDnsSuffixConfiguration
                        = CustomDnsSuffixConfigurationInner.fromJson(reader);
                } else if ("networkingConfiguration".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.networkingConfiguration
                        = AseV3NetworkingConfigurationInner.fromJson(reader);
                } else if ("upgradeAvailability".equals(fieldName)) {
                    deserializedAppServiceEnvironmentInner.upgradeAvailability
                        = UpgradeAvailability.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppServiceEnvironmentInner;
        });
    }
}
