// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * User resource specific properties.
 */
@Fluent
public final class UserProperties implements JsonSerializable<UserProperties> {
    /*
     * Username used for publishing.
     */
    private String publishingUsername;

    /*
     * Password used for publishing.
     */
    private String publishingPassword;

    /*
     * Password hash used for publishing.
     */
    private String publishingPasswordHash;

    /*
     * Password hash salt used for publishing.
     */
    private String publishingPasswordHashSalt;

    /*
     * Url of SCM site.
     */
    private String scmUri;

    /**
     * Creates an instance of UserProperties class.
     */
    public UserProperties() {
    }

    /**
     * Get the publishingUsername property: Username used for publishing.
     * 
     * @return the publishingUsername value.
     */
    public String publishingUsername() {
        return this.publishingUsername;
    }

    /**
     * Set the publishingUsername property: Username used for publishing.
     * 
     * @param publishingUsername the publishingUsername value to set.
     * @return the UserProperties object itself.
     */
    public UserProperties withPublishingUsername(String publishingUsername) {
        this.publishingUsername = publishingUsername;
        return this;
    }

    /**
     * Get the publishingPassword property: Password used for publishing.
     * 
     * @return the publishingPassword value.
     */
    public String publishingPassword() {
        return this.publishingPassword;
    }

    /**
     * Set the publishingPassword property: Password used for publishing.
     * 
     * @param publishingPassword the publishingPassword value to set.
     * @return the UserProperties object itself.
     */
    public UserProperties withPublishingPassword(String publishingPassword) {
        this.publishingPassword = publishingPassword;
        return this;
    }

    /**
     * Get the publishingPasswordHash property: Password hash used for publishing.
     * 
     * @return the publishingPasswordHash value.
     */
    public String publishingPasswordHash() {
        return this.publishingPasswordHash;
    }

    /**
     * Set the publishingPasswordHash property: Password hash used for publishing.
     * 
     * @param publishingPasswordHash the publishingPasswordHash value to set.
     * @return the UserProperties object itself.
     */
    public UserProperties withPublishingPasswordHash(String publishingPasswordHash) {
        this.publishingPasswordHash = publishingPasswordHash;
        return this;
    }

    /**
     * Get the publishingPasswordHashSalt property: Password hash salt used for publishing.
     * 
     * @return the publishingPasswordHashSalt value.
     */
    public String publishingPasswordHashSalt() {
        return this.publishingPasswordHashSalt;
    }

    /**
     * Set the publishingPasswordHashSalt property: Password hash salt used for publishing.
     * 
     * @param publishingPasswordHashSalt the publishingPasswordHashSalt value to set.
     * @return the UserProperties object itself.
     */
    public UserProperties withPublishingPasswordHashSalt(String publishingPasswordHashSalt) {
        this.publishingPasswordHashSalt = publishingPasswordHashSalt;
        return this;
    }

    /**
     * Get the scmUri property: Url of SCM site.
     * 
     * @return the scmUri value.
     */
    public String scmUri() {
        return this.scmUri;
    }

    /**
     * Set the scmUri property: Url of SCM site.
     * 
     * @param scmUri the scmUri value to set.
     * @return the UserProperties object itself.
     */
    public UserProperties withScmUri(String scmUri) {
        this.scmUri = scmUri;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (publishingUsername() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property publishingUsername in model UserProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UserProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publishingUserName", this.publishingUsername);
        jsonWriter.writeStringField("publishingPassword", this.publishingPassword);
        jsonWriter.writeStringField("publishingPasswordHash", this.publishingPasswordHash);
        jsonWriter.writeStringField("publishingPasswordHashSalt", this.publishingPasswordHashSalt);
        jsonWriter.writeStringField("scmUri", this.scmUri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UserProperties.
     */
    public static UserProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserProperties deserializedUserProperties = new UserProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("publishingUserName".equals(fieldName)) {
                    deserializedUserProperties.publishingUsername = reader.getString();
                } else if ("publishingPassword".equals(fieldName)) {
                    deserializedUserProperties.publishingPassword = reader.getString();
                } else if ("publishingPasswordHash".equals(fieldName)) {
                    deserializedUserProperties.publishingPasswordHash = reader.getString();
                } else if ("publishingPasswordHashSalt".equals(fieldName)) {
                    deserializedUserProperties.publishingPasswordHashSalt = reader.getString();
                } else if ("scmUri".equals(fieldName)) {
                    deserializedUserProperties.scmUri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserProperties;
        });
    }
}
