// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.CsmOperationDescriptionInner;
import java.io.IOException;
import java.util.List;

/**
 * Collection of Azure resource manager operation metadata.
 */
@Fluent
public final class CsmOperationCollection implements JsonSerializable<CsmOperationCollection> {
    /*
     * Collection of resources.
     */
    private List<CsmOperationDescriptionInner> value;

    /*
     * Link to next page of resources.
     */
    private String nextLink;

    /**
     * Creates an instance of CsmOperationCollection class.
     */
    public CsmOperationCollection() {
    }

    /**
     * Get the value property: Collection of resources.
     * 
     * @return the value value.
     */
    public List<CsmOperationDescriptionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of resources.
     * 
     * @param value the value value to set.
     * @return the CsmOperationCollection object itself.
     */
    public CsmOperationCollection withValue(List<CsmOperationDescriptionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to next page of resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model CsmOperationCollection"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CsmOperationCollection.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CsmOperationCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CsmOperationCollection if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CsmOperationCollection.
     */
    public static CsmOperationCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CsmOperationCollection deserializedCsmOperationCollection = new CsmOperationCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<CsmOperationDescriptionInner> value
                        = reader.readArray(reader1 -> CsmOperationDescriptionInner.fromJson(reader1));
                    deserializedCsmOperationCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedCsmOperationCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCsmOperationCollection;
        });
    }
}
