// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The routes that specify the endpoints used for login and logout requests.
 */
@Fluent
public final class LoginRoutes implements JsonSerializable<LoginRoutes> {
    /*
     * The endpoint at which a logout request should be made.
     */
    private String logoutEndpoint;

    /**
     * Creates an instance of LoginRoutes class.
     */
    public LoginRoutes() {
    }

    /**
     * Get the logoutEndpoint property: The endpoint at which a logout request should be made.
     * 
     * @return the logoutEndpoint value.
     */
    public String logoutEndpoint() {
        return this.logoutEndpoint;
    }

    /**
     * Set the logoutEndpoint property: The endpoint at which a logout request should be made.
     * 
     * @param logoutEndpoint the logoutEndpoint value to set.
     * @return the LoginRoutes object itself.
     */
    public LoginRoutes withLogoutEndpoint(String logoutEndpoint) {
        this.logoutEndpoint = logoutEndpoint;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("logoutEndpoint", this.logoutEndpoint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LoginRoutes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LoginRoutes if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LoginRoutes.
     */
    public static LoginRoutes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoginRoutes deserializedLoginRoutes = new LoginRoutes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("logoutEndpoint".equals(fieldName)) {
                    deserializedLoginRoutes.logoutEndpoint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLoginRoutes;
        });
    }
}
