/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class CloningInfo
implements JsonSerializable<CloningInfo> {
    private UUID correlationId;
    private Boolean overwrite;
    private Boolean cloneCustomHostNames;
    private Boolean cloneSourceControl;
    private String sourceWebAppId;
    private String sourceWebAppLocation;
    private String hostingEnvironment;
    private Map<String, String> appSettingsOverrides;
    private Boolean configureLoadBalancing;
    private String trafficManagerProfileId;
    private String trafficManagerProfileName;
    private static final ClientLogger LOGGER = new ClientLogger(CloningInfo.class);

    public UUID correlationId() {
        return this.correlationId;
    }

    public CloningInfo withCorrelationId(UUID correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public Boolean overwrite() {
        return this.overwrite;
    }

    public CloningInfo withOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public Boolean cloneCustomHostNames() {
        return this.cloneCustomHostNames;
    }

    public CloningInfo withCloneCustomHostNames(Boolean cloneCustomHostNames) {
        this.cloneCustomHostNames = cloneCustomHostNames;
        return this;
    }

    public Boolean cloneSourceControl() {
        return this.cloneSourceControl;
    }

    public CloningInfo withCloneSourceControl(Boolean cloneSourceControl) {
        this.cloneSourceControl = cloneSourceControl;
        return this;
    }

    public String sourceWebAppId() {
        return this.sourceWebAppId;
    }

    public CloningInfo withSourceWebAppId(String sourceWebAppId) {
        this.sourceWebAppId = sourceWebAppId;
        return this;
    }

    public String sourceWebAppLocation() {
        return this.sourceWebAppLocation;
    }

    public CloningInfo withSourceWebAppLocation(String sourceWebAppLocation) {
        this.sourceWebAppLocation = sourceWebAppLocation;
        return this;
    }

    public String hostingEnvironment() {
        return this.hostingEnvironment;
    }

    public CloningInfo withHostingEnvironment(String hostingEnvironment) {
        this.hostingEnvironment = hostingEnvironment;
        return this;
    }

    public Map<String, String> appSettingsOverrides() {
        return this.appSettingsOverrides;
    }

    public CloningInfo withAppSettingsOverrides(Map<String, String> appSettingsOverrides) {
        this.appSettingsOverrides = appSettingsOverrides;
        return this;
    }

    public Boolean configureLoadBalancing() {
        return this.configureLoadBalancing;
    }

    public CloningInfo withConfigureLoadBalancing(Boolean configureLoadBalancing) {
        this.configureLoadBalancing = configureLoadBalancing;
        return this;
    }

    public String trafficManagerProfileId() {
        return this.trafficManagerProfileId;
    }

    public CloningInfo withTrafficManagerProfileId(String trafficManagerProfileId) {
        this.trafficManagerProfileId = trafficManagerProfileId;
        return this;
    }

    public String trafficManagerProfileName() {
        return this.trafficManagerProfileName;
    }

    public CloningInfo withTrafficManagerProfileName(String trafficManagerProfileName) {
        this.trafficManagerProfileName = trafficManagerProfileName;
        return this;
    }

    public void validate() {
        if (this.sourceWebAppId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceWebAppId in model CloningInfo"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceWebAppId", this.sourceWebAppId);
        jsonWriter.writeStringField("correlationId", Objects.toString(this.correlationId, null));
        jsonWriter.writeBooleanField("overwrite", this.overwrite);
        jsonWriter.writeBooleanField("cloneCustomHostNames", this.cloneCustomHostNames);
        jsonWriter.writeBooleanField("cloneSourceControl", this.cloneSourceControl);
        jsonWriter.writeStringField("sourceWebAppLocation", this.sourceWebAppLocation);
        jsonWriter.writeStringField("hostingEnvironment", this.hostingEnvironment);
        jsonWriter.writeMapField("appSettingsOverrides", this.appSettingsOverrides, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("configureLoadBalancing", this.configureLoadBalancing);
        jsonWriter.writeStringField("trafficManagerProfileId", this.trafficManagerProfileId);
        jsonWriter.writeStringField("trafficManagerProfileName", this.trafficManagerProfileName);
        return jsonWriter.writeEndObject();
    }

    public static CloningInfo fromJson(JsonReader jsonReader) throws IOException {
        return (CloningInfo)jsonReader.readObject(reader -> {
            CloningInfo deserializedCloningInfo = new CloningInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceWebAppId".equals(fieldName)) {
                    deserializedCloningInfo.sourceWebAppId = reader.getString();
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedCloningInfo.correlationId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("overwrite".equals(fieldName)) {
                    deserializedCloningInfo.overwrite = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("cloneCustomHostNames".equals(fieldName)) {
                    deserializedCloningInfo.cloneCustomHostNames = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("cloneSourceControl".equals(fieldName)) {
                    deserializedCloningInfo.cloneSourceControl = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sourceWebAppLocation".equals(fieldName)) {
                    deserializedCloningInfo.sourceWebAppLocation = reader.getString();
                    continue;
                }
                if ("hostingEnvironment".equals(fieldName)) {
                    deserializedCloningInfo.hostingEnvironment = reader.getString();
                    continue;
                }
                if ("appSettingsOverrides".equals(fieldName)) {
                    Map appSettingsOverrides;
                    deserializedCloningInfo.appSettingsOverrides = appSettingsOverrides = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("configureLoadBalancing".equals(fieldName)) {
                    deserializedCloningInfo.configureLoadBalancing = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("trafficManagerProfileId".equals(fieldName)) {
                    deserializedCloningInfo.trafficManagerProfileId = reader.getString();
                    continue;
                }
                if ("trafficManagerProfileName".equals(fieldName)) {
                    deserializedCloningInfo.trafficManagerProfileName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloningInfo;
        });
    }
}

