// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * GeoRegion resource specific properties.
 */
@Immutable
public final class GeoRegionProperties implements JsonSerializable<GeoRegionProperties> {
    /*
     * Region description.
     */
    private String description;

    /*
     * Display name for region.
     */
    private String displayName;

    /*
     * Display name for region.
     */
    private String orgDomain;

    /**
     * Creates an instance of GeoRegionProperties class.
     */
    public GeoRegionProperties() {
    }

    /**
     * Get the description property: Region description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the displayName property: Display name for region.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the orgDomain property: Display name for region.
     * 
     * @return the orgDomain value.
     */
    public String orgDomain() {
        return this.orgDomain;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GeoRegionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GeoRegionProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the GeoRegionProperties.
     */
    public static GeoRegionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GeoRegionProperties deserializedGeoRegionProperties = new GeoRegionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedGeoRegionProperties.description = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedGeoRegionProperties.displayName = reader.getString();
                } else if ("orgDomain".equals(fieldName)) {
                    deserializedGeoRegionProperties.orgDomain = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGeoRegionProperties;
        });
    }
}
