// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * Response for a migration of app content request.
 */
@Fluent
public final class StorageMigrationResponseInner extends ProxyOnlyResource {
    /*
     * StorageMigrationResponse resource specific properties
     */
    private StorageMigrationResponseProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of StorageMigrationResponseInner class.
     */
    public StorageMigrationResponseInner() {
    }

    /**
     * Get the innerProperties property: StorageMigrationResponse resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private StorageMigrationResponseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StorageMigrationResponseInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the operationId property: When server starts the migration process, it will return an operation ID
     * identifying that particular migration operation.
     * 
     * @return the operationId value.
     */
    public String operationId() {
        return this.innerProperties() == null ? null : this.innerProperties().operationId();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageMigrationResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageMigrationResponseInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StorageMigrationResponseInner.
     */
    public static StorageMigrationResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageMigrationResponseInner deserializedStorageMigrationResponseInner
                = new StorageMigrationResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStorageMigrationResponseInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStorageMigrationResponseInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStorageMigrationResponseInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedStorageMigrationResponseInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedStorageMigrationResponseInner.innerProperties
                        = StorageMigrationResponseProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageMigrationResponseInner;
        });
    }
}
