// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Http logs to azure blob storage configuration.
 */
@Fluent
public final class AzureBlobStorageHttpLogsConfig implements JsonSerializable<AzureBlobStorageHttpLogsConfig> {
    /*
     * SAS url to a azure blob container with read/write/list/delete permissions.
     */
    private String sasUrl;

    /*
     * Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     */
    private Integer retentionInDays;

    /*
     * True if configuration is enabled, false if it is disabled and null if configuration is not set.
     */
    private Boolean enabled;

    /**
     * Creates an instance of AzureBlobStorageHttpLogsConfig class.
     */
    public AzureBlobStorageHttpLogsConfig() {
    }

    /**
     * Get the sasUrl property: SAS url to a azure blob container with read/write/list/delete permissions.
     * 
     * @return the sasUrl value.
     */
    public String sasUrl() {
        return this.sasUrl;
    }

    /**
     * Set the sasUrl property: SAS url to a azure blob container with read/write/list/delete permissions.
     * 
     * @param sasUrl the sasUrl value to set.
     * @return the AzureBlobStorageHttpLogsConfig object itself.
     */
    public AzureBlobStorageHttpLogsConfig withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    /**
     * Get the retentionInDays property: Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     * 
     * @return the retentionInDays value.
     */
    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    /**
     * Set the retentionInDays property: Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     * 
     * @param retentionInDays the retentionInDays value to set.
     * @return the AzureBlobStorageHttpLogsConfig object itself.
     */
    public AzureBlobStorageHttpLogsConfig withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    /**
     * Get the enabled property: True if configuration is enabled, false if it is disabled and null if configuration is
     * not set.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: True if configuration is enabled, false if it is disabled and null if configuration is
     * not set.
     * 
     * @param enabled the enabled value to set.
     * @return the AzureBlobStorageHttpLogsConfig object itself.
     */
    public AzureBlobStorageHttpLogsConfig withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sasUrl", this.sasUrl);
        jsonWriter.writeNumberField("retentionInDays", this.retentionInDays);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureBlobStorageHttpLogsConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureBlobStorageHttpLogsConfig if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureBlobStorageHttpLogsConfig.
     */
    public static AzureBlobStorageHttpLogsConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureBlobStorageHttpLogsConfig deserializedAzureBlobStorageHttpLogsConfig
                = new AzureBlobStorageHttpLogsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sasUrl".equals(fieldName)) {
                    deserializedAzureBlobStorageHttpLogsConfig.sasUrl = reader.getString();
                } else if ("retentionInDays".equals(fieldName)) {
                    deserializedAzureBlobStorageHttpLogsConfig.retentionInDays = reader.getNullable(JsonReader::getInt);
                } else if ("enabled".equals(fieldName)) {
                    deserializedAzureBlobStorageHttpLogsConfig.enabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureBlobStorageHttpLogsConfig;
        });
    }
}
