// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Container App Dapr configuration.
 */
@Fluent
public final class Dapr implements JsonSerializable<Dapr> {
    /*
     * Boolean indicating if the Dapr side car is enabled
     */
    private Boolean enabled;

    /*
     * Dapr application identifier
     */
    private String appId;

    /*
     * Port on which the Dapr side car
     */
    private Integer appPort;

    /*
     * Collection of Dapr components
     */
    private List<DaprComponent> components;

    /**
     * Creates an instance of Dapr class.
     */
    public Dapr() {
    }

    /**
     * Get the enabled property: Boolean indicating if the Dapr side car is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Boolean indicating if the Dapr side car is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the Dapr object itself.
     */
    public Dapr withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the appId property: Dapr application identifier.
     * 
     * @return the appId value.
     */
    public String appId() {
        return this.appId;
    }

    /**
     * Set the appId property: Dapr application identifier.
     * 
     * @param appId the appId value to set.
     * @return the Dapr object itself.
     */
    public Dapr withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    /**
     * Get the appPort property: Port on which the Dapr side car.
     * 
     * @return the appPort value.
     */
    public Integer appPort() {
        return this.appPort;
    }

    /**
     * Set the appPort property: Port on which the Dapr side car.
     * 
     * @param appPort the appPort value to set.
     * @return the Dapr object itself.
     */
    public Dapr withAppPort(Integer appPort) {
        this.appPort = appPort;
        return this;
    }

    /**
     * Get the components property: Collection of Dapr components.
     * 
     * @return the components value.
     */
    public List<DaprComponent> components() {
        return this.components;
    }

    /**
     * Set the components property: Collection of Dapr components.
     * 
     * @param components the components value to set.
     * @return the Dapr object itself.
     */
    public Dapr withComponents(List<DaprComponent> components) {
        this.components = components;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (components() != null) {
            components().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("appId", this.appId);
        jsonWriter.writeNumberField("appPort", this.appPort);
        jsonWriter.writeArrayField("components", this.components, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Dapr from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Dapr if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Dapr.
     */
    public static Dapr fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Dapr deserializedDapr = new Dapr();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedDapr.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("appId".equals(fieldName)) {
                    deserializedDapr.appId = reader.getString();
                } else if ("appPort".equals(fieldName)) {
                    deserializedDapr.appPort = reader.getNullable(JsonReader::getInt);
                } else if ("components".equals(fieldName)) {
                    List<DaprComponent> components = reader.readArray(reader1 -> DaprComponent.fromJson(reader1));
                    deserializedDapr.components = components;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDapr;
        });
    }
}
