/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.DetectorResponseInner;
import java.io.IOException;
import java.util.List;

public final class DetectorResponseCollection
implements JsonSerializable<DetectorResponseCollection> {
    private List<DetectorResponseInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DetectorResponseCollection.class);

    public List<DetectorResponseInner> value() {
        return this.value;
    }

    public DetectorResponseCollection withValue(List<DetectorResponseInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DetectorResponseCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DetectorResponseCollection fromJson(JsonReader jsonReader) throws IOException {
        return (DetectorResponseCollection)jsonReader.readObject(reader -> {
            DetectorResponseCollection deserializedDetectorResponseCollection = new DetectorResponseCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDetectorResponseCollection.value = value = reader.readArray(reader1 -> DetectorResponseInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDetectorResponseCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDetectorResponseCollection;
        });
    }
}

