/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class DomainPurchaseConsent
implements JsonSerializable<DomainPurchaseConsent> {
    private List<String> agreementKeys;
    private String agreedBy;
    private OffsetDateTime agreedAt;

    public List<String> agreementKeys() {
        return this.agreementKeys;
    }

    public DomainPurchaseConsent withAgreementKeys(List<String> agreementKeys) {
        this.agreementKeys = agreementKeys;
        return this;
    }

    public String agreedBy() {
        return this.agreedBy;
    }

    public DomainPurchaseConsent withAgreedBy(String agreedBy) {
        this.agreedBy = agreedBy;
        return this;
    }

    public OffsetDateTime agreedAt() {
        return this.agreedAt;
    }

    public DomainPurchaseConsent withAgreedAt(OffsetDateTime agreedAt) {
        this.agreedAt = agreedAt;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("agreementKeys", this.agreementKeys, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("agreedBy", this.agreedBy);
        jsonWriter.writeStringField("agreedAt", this.agreedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.agreedAt));
        return jsonWriter.writeEndObject();
    }

    public static DomainPurchaseConsent fromJson(JsonReader jsonReader) throws IOException {
        return (DomainPurchaseConsent)jsonReader.readObject(reader -> {
            DomainPurchaseConsent deserializedDomainPurchaseConsent = new DomainPurchaseConsent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("agreementKeys".equals(fieldName)) {
                    List agreementKeys;
                    deserializedDomainPurchaseConsent.agreementKeys = agreementKeys = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("agreedBy".equals(fieldName)) {
                    deserializedDomainPurchaseConsent.agreedBy = reader.getString();
                    continue;
                }
                if ("agreedAt".equals(fieldName)) {
                    deserializedDomainPurchaseConsent.agreedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDomainPurchaseConsent;
        });
    }
}

