/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ClientCredentialMethod;
import java.io.IOException;

public final class OpenIdConnectClientCredential
implements JsonSerializable<OpenIdConnectClientCredential> {
    private ClientCredentialMethod method;
    private String clientSecretSettingName;

    public ClientCredentialMethod method() {
        return this.method;
    }

    public OpenIdConnectClientCredential withMethod(ClientCredentialMethod method) {
        this.method = method;
        return this;
    }

    public String clientSecretSettingName() {
        return this.clientSecretSettingName;
    }

    public OpenIdConnectClientCredential withClientSecretSettingName(String clientSecretSettingName) {
        this.clientSecretSettingName = clientSecretSettingName;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
        jsonWriter.writeStringField("clientSecretSettingName", this.clientSecretSettingName);
        return jsonWriter.writeEndObject();
    }

    public static OpenIdConnectClientCredential fromJson(JsonReader jsonReader) throws IOException {
        return (OpenIdConnectClientCredential)jsonReader.readObject(reader -> {
            OpenIdConnectClientCredential deserializedOpenIdConnectClientCredential = new OpenIdConnectClientCredential();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("method".equals(fieldName)) {
                    deserializedOpenIdConnectClientCredential.method = ClientCredentialMethod.fromString(reader.getString());
                    continue;
                }
                if ("clientSecretSettingName".equals(fieldName)) {
                    deserializedOpenIdConnectClientCredential.clientSecretSettingName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenIdConnectClientCredential;
        });
    }
}

