/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.StaticSite;
import com.azure.resourcemanager.appservice.models.DatabaseConnectionOverview;
import com.azure.resourcemanager.appservice.models.EnterpriseGradeCdnStatus;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.ResponseMessageEnvelopeRemotePrivateEndpointConnection;
import com.azure.resourcemanager.appservice.models.StagingEnvironmentPolicy;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildProperties;
import com.azure.resourcemanager.appservice.models.StaticSiteLinkedBackend;
import com.azure.resourcemanager.appservice.models.StaticSiteTemplateOptions;
import com.azure.resourcemanager.appservice.models.StaticSiteUserProvidedFunctionApp;
import java.io.IOException;
import java.util.List;

public final class StaticSitePatchResource
extends ProxyOnlyResource {
    private StaticSite innerProperties;
    private String type;
    private String name;
    private String id;

    private StaticSite innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public StaticSitePatchResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String defaultHostname() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultHostname();
    }

    public String repositoryUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().repositoryUrl();
    }

    public StaticSitePatchResource withRepositoryUrl(String repositoryUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withRepositoryUrl(repositoryUrl);
        return this;
    }

    public String branch() {
        return this.innerProperties() == null ? null : this.innerProperties().branch();
    }

    public StaticSitePatchResource withBranch(String branch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withBranch(branch);
        return this;
    }

    public List<String> customDomains() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomains();
    }

    public String repositoryToken() {
        return this.innerProperties() == null ? null : this.innerProperties().repositoryToken();
    }

    public StaticSitePatchResource withRepositoryToken(String repositoryToken) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withRepositoryToken(repositoryToken);
        return this;
    }

    public StaticSiteBuildProperties buildProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().buildProperties();
    }

    public StaticSitePatchResource withBuildProperties(StaticSiteBuildProperties buildProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withBuildProperties(buildProperties);
        return this;
    }

    public List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public StagingEnvironmentPolicy stagingEnvironmentPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().stagingEnvironmentPolicy();
    }

    public StaticSitePatchResource withStagingEnvironmentPolicy(StagingEnvironmentPolicy stagingEnvironmentPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withStagingEnvironmentPolicy(stagingEnvironmentPolicy);
        return this;
    }

    public Boolean allowConfigFileUpdates() {
        return this.innerProperties() == null ? null : this.innerProperties().allowConfigFileUpdates();
    }

    public StaticSitePatchResource withAllowConfigFileUpdates(Boolean allowConfigFileUpdates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withAllowConfigFileUpdates(allowConfigFileUpdates);
        return this;
    }

    public StaticSiteTemplateOptions templateProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().templateProperties();
    }

    public StaticSitePatchResource withTemplateProperties(StaticSiteTemplateOptions templateProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withTemplateProperties(templateProperties);
        return this;
    }

    public String contentDistributionEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().contentDistributionEndpoint();
    }

    public String keyVaultReferenceIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultReferenceIdentity();
    }

    public List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps() {
        return this.innerProperties() == null ? null : this.innerProperties().userProvidedFunctionApps();
    }

    public List<StaticSiteLinkedBackend> linkedBackends() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedBackends();
    }

    public String provider() {
        return this.innerProperties() == null ? null : this.innerProperties().provider();
    }

    public StaticSitePatchResource withProvider(String provider) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withProvider(provider);
        return this;
    }

    public EnterpriseGradeCdnStatus enterpriseGradeCdnStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().enterpriseGradeCdnStatus();
    }

    public StaticSitePatchResource withEnterpriseGradeCdnStatus(EnterpriseGradeCdnStatus enterpriseGradeCdnStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withEnterpriseGradeCdnStatus(enterpriseGradeCdnStatus);
        return this;
    }

    public String publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public StaticSitePatchResource withPublicNetworkAccess(String publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSite();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public List<DatabaseConnectionOverview> databaseConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseConnections();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static StaticSitePatchResource fromJson(JsonReader jsonReader) throws IOException {
        return (StaticSitePatchResource)((Object)jsonReader.readObject(reader -> {
            StaticSitePatchResource deserializedStaticSitePatchResource = new StaticSitePatchResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedStaticSitePatchResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedStaticSitePatchResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStaticSitePatchResource.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedStaticSitePatchResource.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStaticSitePatchResource.innerProperties = StaticSite.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStaticSitePatchResource;
        }));
    }
}

