/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WorkflowProperties;
import com.azure.resourcemanager.appservice.models.FlowAccessControlConfiguration;
import com.azure.resourcemanager.appservice.models.FlowEndpointsConfiguration;
import com.azure.resourcemanager.appservice.models.Kind;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowParameter;
import com.azure.resourcemanager.appservice.models.WorkflowProvisioningState;
import com.azure.resourcemanager.appservice.models.WorkflowResource;
import com.azure.resourcemanager.appservice.models.WorkflowSku;
import com.azure.resourcemanager.appservice.models.WorkflowState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class Workflow
extends WorkflowResource {
    private WorkflowProperties innerProperties;
    private ManagedServiceIdentity identity;
    private String type;
    private String name;
    private String id;

    private WorkflowProperties innerProperties() {
        return this.innerProperties;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public Workflow withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Workflow withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public Workflow withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public WorkflowProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    public OffsetDateTime changedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().changedTime();
    }

    public WorkflowState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public Workflow withState(WorkflowState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public String accessEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().accessEndpoint();
    }

    public FlowEndpointsConfiguration endpointsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointsConfiguration();
    }

    public Workflow withEndpointsConfiguration(FlowEndpointsConfiguration endpointsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withEndpointsConfiguration(endpointsConfiguration);
        return this;
    }

    public FlowAccessControlConfiguration accessControl() {
        return this.innerProperties() == null ? null : this.innerProperties().accessControl();
    }

    public Workflow withAccessControl(FlowAccessControlConfiguration accessControl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withAccessControl(accessControl);
        return this;
    }

    public WorkflowSku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public ResourceReference integrationAccount() {
        return this.innerProperties() == null ? null : this.innerProperties().integrationAccount();
    }

    public Workflow withIntegrationAccount(ResourceReference integrationAccount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withIntegrationAccount(integrationAccount);
        return this;
    }

    public ResourceReference integrationServiceEnvironment() {
        return this.innerProperties() == null ? null : this.innerProperties().integrationServiceEnvironment();
    }

    public Workflow withIntegrationServiceEnvironment(ResourceReference integrationServiceEnvironment) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withIntegrationServiceEnvironment(integrationServiceEnvironment);
        return this;
    }

    public Object definition() {
        return this.innerProperties() == null ? null : this.innerProperties().definition();
    }

    public Workflow withDefinition(Object definition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withDefinition(definition);
        return this;
    }

    public Map<String, WorkflowParameter> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public Workflow withParameters(Map<String, WorkflowParameter> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public Kind kind() {
        return this.innerProperties() == null ? null : this.innerProperties().kind();
    }

    public Workflow withKind(Kind kind) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static Workflow fromJson(JsonReader jsonReader) throws IOException {
        return (Workflow)((Object)jsonReader.readObject(reader -> {
            Workflow deserializedWorkflow = new Workflow();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkflow.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkflow.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkflow.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWorkflow.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedWorkflow.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkflow.innerProperties = WorkflowProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedWorkflow.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflow;
        }));
    }
}

