// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.KeyVaultSecretStatus;
import java.io.IOException;

/**
 * Key Vault container for a certificate that is purchased through Azure.
 */
@Fluent
public final class AppServiceCertificateInner implements JsonSerializable<AppServiceCertificateInner> {
    /*
     * Key Vault resource Id.
     */
    private String keyVaultId;

    /*
     * Key Vault secret name.
     */
    private String keyVaultSecretName;

    /*
     * Status of the Key Vault secret.
     */
    private KeyVaultSecretStatus provisioningState;

    /**
     * Creates an instance of AppServiceCertificateInner class.
     */
    public AppServiceCertificateInner() {
    }

    /**
     * Get the keyVaultId property: Key Vault resource Id.
     * 
     * @return the keyVaultId value.
     */
    public String keyVaultId() {
        return this.keyVaultId;
    }

    /**
     * Set the keyVaultId property: Key Vault resource Id.
     * 
     * @param keyVaultId the keyVaultId value to set.
     * @return the AppServiceCertificateInner object itself.
     */
    public AppServiceCertificateInner withKeyVaultId(String keyVaultId) {
        this.keyVaultId = keyVaultId;
        return this;
    }

    /**
     * Get the keyVaultSecretName property: Key Vault secret name.
     * 
     * @return the keyVaultSecretName value.
     */
    public String keyVaultSecretName() {
        return this.keyVaultSecretName;
    }

    /**
     * Set the keyVaultSecretName property: Key Vault secret name.
     * 
     * @param keyVaultSecretName the keyVaultSecretName value to set.
     * @return the AppServiceCertificateInner object itself.
     */
    public AppServiceCertificateInner withKeyVaultSecretName(String keyVaultSecretName) {
        this.keyVaultSecretName = keyVaultSecretName;
        return this;
    }

    /**
     * Get the provisioningState property: Status of the Key Vault secret.
     * 
     * @return the provisioningState value.
     */
    public KeyVaultSecretStatus provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultId", this.keyVaultId);
        jsonWriter.writeStringField("keyVaultSecretName", this.keyVaultSecretName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppServiceCertificateInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppServiceCertificateInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AppServiceCertificateInner.
     */
    public static AppServiceCertificateInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppServiceCertificateInner deserializedAppServiceCertificateInner = new AppServiceCertificateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyVaultId".equals(fieldName)) {
                    deserializedAppServiceCertificateInner.keyVaultId = reader.getString();
                } else if ("keyVaultSecretName".equals(fieldName)) {
                    deserializedAppServiceCertificateInner.keyVaultSecretName = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedAppServiceCertificateInner.provisioningState
                        = KeyVaultSecretStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppServiceCertificateInner;
        });
    }
}
