// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * SSL certificate email.
 */
@Fluent
public final class CertificateEmailInner implements JsonSerializable<CertificateEmailInner> {
    /*
     * Email id.
     */
    private String emailId;

    /*
     * Time stamp.
     */
    private OffsetDateTime timestamp;

    /**
     * Creates an instance of CertificateEmailInner class.
     */
    public CertificateEmailInner() {
    }

    /**
     * Get the emailId property: Email id.
     * 
     * @return the emailId value.
     */
    public String emailId() {
        return this.emailId;
    }

    /**
     * Set the emailId property: Email id.
     * 
     * @param emailId the emailId value to set.
     * @return the CertificateEmailInner object itself.
     */
    public CertificateEmailInner withEmailId(String emailId) {
        this.emailId = emailId;
        return this;
    }

    /**
     * Get the timestamp property: Time stamp.
     * 
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: Time stamp.
     * 
     * @param timestamp the timestamp value to set.
     * @return the CertificateEmailInner object itself.
     */
    public CertificateEmailInner withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("emailId", this.emailId);
        jsonWriter.writeStringField("timeStamp",
            this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateEmailInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateEmailInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateEmailInner.
     */
    public static CertificateEmailInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateEmailInner deserializedCertificateEmailInner = new CertificateEmailInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("emailId".equals(fieldName)) {
                    deserializedCertificateEmailInner.emailId = reader.getString();
                } else if ("timeStamp".equals(fieldName)) {
                    deserializedCertificateEmailInner.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateEmailInner;
        });
    }
}
